/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.collector;

import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.mongodb.ConnectionCloseReason;
import com.lubanops.apm.plugin.mongodb.stats.MongoConnectionStats;
import java.util.Map;

public class MongoConnectionAggregator
extends SinglePrimaryKeyAggregator<MongoConnectionStats> {
    private int timeSpanThreshold = 1;
    private final ThreadLocal<MongoConnectionStats> statsLocal = new ThreadLocal();
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private static final String TIME_SPAN_THRESHOLD = "MongoConnectionTimeSpanThreshold";
    private static final String HOST = "host";

    public void parseParameters(Map<String, String> parameters) {
        Integer timeSpanThreshold = ParameterParseUtil.getInteger(parameters, (String)TIME_SPAN_THRESHOLD);
        if (timeSpanThreshold != null) {
            this.timeSpanThreshold = timeSpanThreshold;
        }
    }

    public void onStart(String host) {
        if (!this.isEnable) {
            return;
        }
        MongoConnectionStats stats = (MongoConnectionStats)this.getValue(host);
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
    }

    public void onError() {
        if (!this.isEnable) {
            return;
        }
        MongoConnectionStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.incrementErrorCount();
        }
    }

    public void onFinally() {
        if (!this.isEnable) {
            return;
        }
        MongoConnectionStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            Long endTime = System.nanoTime();
            stats.onFinally(endTime - startTime);
            this.statsLocal.set(null);
            this.startTimeLocal.set(null);
        }
    }

    public void onConnectionOpen(String host) {
        if (!this.isEnable) {
            return;
        }
        MongoConnectionStats stats = (MongoConnectionStats)this.getValue(host);
        stats.incrementOpenedCount();
    }

    public void onConnectionClose(String host, ConnectionCloseReason reason) {
        if (!this.isEnable) {
            return;
        }
        MongoConnectionStats stats = (MongoConnectionStats)this.getValue(host);
        stats.incrementClosedCount();
        if (ConnectionCloseReason.STALE.equals((Object)reason)) {
            stats.incrementStaleClosedCount();
        } else if (ConnectionCloseReason.MAX_LIFE_TIME_EXCEEDED.equals((Object)reason)) {
            stats.incrementLifeClosedCount();
        } else if (ConnectionCloseReason.MAX_IDLE_TIME_EXCEEDED.equals((Object)reason)) {
            stats.incrementIdleClosedCount();
        } else if (ConnectionCloseReason.ERROR.equals((Object)reason)) {
            stats.incrementErrorClosedCount();
        } else if (ConnectionCloseReason.POOL_CLOSED.equals((Object)reason)) {
            stats.incrementPoolClosedClosedCount();
        }
    }

    public int getTimeSpanThreshold() {
        return this.timeSpanThreshold;
    }

    protected Class<MongoConnectionStats> getValueType() {
        return MongoConnectionStats.class;
    }

    public String getName() {
        return "connection";
    }

    protected String primaryKey() {
        return HOST;
    }
}

