/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import one.jfr.ClassRef;
import one.jfr.JfrReader;
import one.jfr.MethodRef;
import one.jfr.StackTrace;
import one.jfr.event.Event;
import one.jfr.event.EventAggregator;
import one.jfr.event.ExecutionSample;
import one.proto.Proto;

public class jfr2nflx {
    private static final String[] FRAME_TYPE = new String[]{"jit", "jit", "inlined", "user", "user", "kernel", "jit"};
    private static final byte[] NO_STACK = "[no_stack]".getBytes();
    private static final byte[] UNKNOWN = "[unknown]".getBytes();
    private final JfrReader jfr;
    private final List<ExecutionSample> samples;

    public jfr2nflx(JfrReader jfrReader) throws IOException {
        this.jfr = jfrReader;
        this.samples = jfrReader.readAllEvents(ExecutionSample.class);
    }

    public void dump(OutputStream outputStream) throws IOException {
        long l = System.nanoTime();
        int n = this.samples.size();
        long l2 = n == 0 ? 0L : this.samples.get((int)(n - 1)).time - this.jfr.startTicks + 1L;
        final Proto proto = new Proto(200000).field(1, 0.0).field(2, Math.max((double)this.jfr.durationNanos() / 1.0E9, (double)l2 / (double)this.jfr.ticksPerSec)).field(3, this.packSamples()).field(4, this.packDeltas()).field(6, "async-profiler").field(8, new Proto(32).field(1, "has_node_stack").field(2, "true")).field(8, new Proto(32).field(1, "has_samples_tid").field(2, "true")).field(11, this.packTids());
        final Proto proto2 = new Proto(10000);
        final Proto proto3 = new Proto(10000);
        EventAggregator eventAggregator = new EventAggregator(false, false);
        for (ExecutionSample executionSample : this.samples) {
            eventAggregator.collect(executionSample);
        }
        eventAggregator.forEach(new EventAggregator.Visitor(){

            @Override
            public void visit(Event event, long l) {
                StackTrace stackTrace = ((jfr2nflx)jfr2nflx.this).jfr.stackTraces.get(event.stackTraceId);
                if (stackTrace != null) {
                    proto.field(5, proto2.field(1, event.stackTraceId).field(2, jfr2nflx.this.packNode(proto3, stackTrace)));
                    proto2.reset();
                    proto3.reset();
                }
            }
        });
        outputStream.write(proto.buffer(), 0, proto.size());
        long l3 = System.nanoTime();
        System.out.println("Wrote " + proto.size() + " bytes in " + (double)(l3 - l) / 1.0E9 + " s");
    }

    private Proto packNode(Proto proto, StackTrace stackTrace) {
        long[] lArray = stackTrace.methods;
        byte[] byArray = stackTrace.types;
        int n = lArray.length - 1;
        proto.field(1, n >= 0 ? this.getMethodName(lArray[n], byArray[n]) : NO_STACK);
        proto.field(2, 1);
        proto.field(4, n >= 0 ? FRAME_TYPE[byArray[n]] : "user");
        Proto proto2 = new Proto(100);
        while (--n >= 0) {
            proto.field(10, proto2.field(1, this.getMethodName(lArray[n], byArray[n])).field(2, FRAME_TYPE[byArray[n]]));
            proto2.reset();
        }
        return proto;
    }

    private Proto packSamples() {
        Proto proto = new Proto(10000);
        for (ExecutionSample executionSample : this.samples) {
            proto.writeInt(executionSample.stackTraceId);
        }
        return proto;
    }

    private Proto packDeltas() {
        Proto proto = new Proto(10000);
        double d = this.jfr.ticksPerSec;
        long l = this.jfr.startTicks;
        for (ExecutionSample executionSample : this.samples) {
            proto.writeDouble((double)(executionSample.time - l) / d);
            l = executionSample.time;
        }
        return proto;
    }

    private Proto packTids() {
        Proto proto = new Proto(10000);
        for (ExecutionSample executionSample : this.samples) {
            proto.writeInt(executionSample.tid);
        }
        return proto;
    }

    private byte[] getMethodName(long l, byte by) {
        MethodRef methodRef = this.jfr.methods.get(l);
        if (methodRef == null) {
            return UNKNOWN;
        }
        ClassRef classRef = this.jfr.classes.get(methodRef.cls);
        byte[] byArray = this.jfr.symbols.get(classRef.name);
        byte[] byArray2 = this.jfr.symbols.get(methodRef.name);
        if (by >= 3 && by <= 5 || byArray == null || byArray.length == 0) {
            return byArray2;
        }
        byte[] byArray3 = Arrays.copyOf(byArray, byArray.length + 1 + byArray2.length);
        byArray3[byArray.length] = 46;
        System.arraycopy(byArray2, 0, byArray3, byArray.length + 1, byArray2.length);
        return byArray3;
    }

    public static void main(String[] stringArray) throws Exception {
        File file;
        if (stringArray.length < 2) {
            System.out.println("Usage: java " + jfr2nflx.class.getName() + " input.jfr output.nflx");
            System.exit(1);
        }
        if ((file = new File(stringArray[1])).isDirectory()) {
            file = new File(file, new File(stringArray[0]).getName().replace(".jfr", ".nflx"));
        }
        try (JfrReader jfrReader = new JfrReader(stringArray[0]);
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            new jfr2nflx(jfrReader).dump(fileOutputStream);
        }
    }
}

