/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.coapcalifornium.client.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.plugin.coapcalifornium.CoapUtils;
import com.lubanops.apm.plugin.coapcalifornium.client.collector.CoapClientAggregator;
import com.lubanops.apm.plugin.coapcalifornium.client.collector.CoapStatusInfoAggregator;
import com.lubanops.apm.plugin.coapcalifornium.stats.CoapStats;
import java.util.Map;

public class CoapClientCollector
extends Collector {
    public static final CoapClientCollector INSTANCE = new CoapClientCollector();
    private static final CoapClientAggregator COAP_CLIENT_AGGREGATOR = new CoapClientAggregator();
    private static final CoapStatusInfoAggregator COAP_STATUS_INFO_AGGREGATOR = new CoapStatusInfoAggregator();
    private static final DefaultVersionAggregator VERSION_AGGREGATOR = new DefaultVersionAggregator();

    public static void setVersion(String version) {
        VERSION_AGGREGATOR.setVersion(version);
    }

    public static Map<String, Object> onStart(String requestUri, String requestType, String methodType) {
        if ((requestUri = CoapUtils.trimSuffix(requestUri)) != null) {
            return COAP_CLIENT_AGGREGATOR.onStart(requestUri, requestType, methodType);
        }
        return null;
    }

    public static void onStatusInfo(boolean isSuccess, String statusInfo, String url, CoapStats stats, String traceId) {
        COAP_STATUS_INFO_AGGREGATOR.onStatusInfo(url, statusInfo);
        if (!isSuccess) {
            COAP_CLIENT_AGGREGATOR.onError(stats, traceId);
        }
    }

    public static void conRequestOnResponseClose(boolean isSuccess, CoapStats stats, Long startTime, String envId, String traceId) {
        COAP_CLIENT_AGGREGATOR.conRequestOnResponseClose(isSuccess, stats, startTime, envId, traceId);
    }

    public static void nonRequestSent(CoapStats stats, Long startTime) {
        COAP_CLIENT_AGGREGATOR.nonRequestSent(stats, startTime);
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public String getCollectorName() {
        return "CoapClient";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)COAP_CLIENT_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)COAP_STATUS_INFO_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)VERSION_AGGREGATOR);
        INSTANCE.register();
    }
}

