/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.goldenDB.interceptor;

import com.goldendb.jdbc.StatementImpl;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.plugin.goldenDB.interceptor.PreparedStatementInteceptor;
import com.lubanops.apm.plugin.goldenDB.util.GoldenDBTrace;

public class StatementExecuteUpdateInterceptor
implements Interceptor {
    public Object[] onStart(Object mysql8Object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                StatementImpl statement = (StatementImpl)mysql8Object;
                String mysql8Sql = (String)args[0];
                Integer id = PreparedStatementInteceptor.getConnectionId(statement);
                PreparedStatementInteceptor.onStart(mysql8Sql, id);
                GoldenDBTrace.onStart(className, methodName, mysql8Sql, mysql8Sql, id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                String sql = (String)args[0];
                Integer updateCount = Integer.valueOf(String.valueOf(result));
                MysqlCollector.onFinally((int)updateCount, (int)0);
                GoldenDBTrace.onFinally(updateCount, 0, null);
                MysqlCollector.onConnectionEnd((String)sql, (int)updateCount, (int)0);
            }
        }
        catch (Exception exception) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)exception);
        }
    }

    public void onError(Object object, Object[] args, Throwable throwable, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                String sql = (String)args[0];
                PreparedStatementInteceptor.onError(sql, throwable);
                GoldenDBTrace.onError(throwable);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "StatementExecuteUpdateInterceptor onError", (Throwable)ex);
        }
    }
}

