/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.util;

import com.huawei.gauss200.jdbc.PGProperty;
import com.huawei.gauss200.jdbc.util.GT;
import com.huawei.gauss200.jdbc.util.PSQLException;
import com.huawei.gauss200.jdbc.util.PSQLState;
import com.huawei.shade.com.alibaba.fastjson.JSONObject;
import com.huawei.shade.com.cloud.sdk.DefaultRequest;
import com.huawei.shade.com.cloud.sdk.auth.credentials.BasicCredentials;
import com.huawei.shade.com.cloud.sdk.auth.signer.Signer;
import com.huawei.shade.com.cloud.sdk.auth.signer.SignerFactory;
import com.huawei.shade.com.cloud.sdk.http.HttpMethodName;
import com.huawei.shade.org.apache.http.Header;
import com.huawei.shade.org.apache.http.client.config.RequestConfig;
import com.huawei.shade.org.apache.http.client.methods.CloseableHttpResponse;
import com.huawei.shade.org.apache.http.client.methods.HttpGet;
import com.huawei.shade.org.apache.http.client.methods.HttpPost;
import com.huawei.shade.org.apache.http.client.methods.HttpRequestBase;
import com.huawei.shade.org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import com.huawei.shade.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.huawei.shade.org.apache.http.conn.ssl.SSLContexts;
import com.huawei.shade.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import com.huawei.shade.org.apache.http.conn.ssl.X509HostnameVerifier;
import com.huawei.shade.org.apache.http.entity.StringEntity;
import com.huawei.shade.org.apache.http.impl.client.CloseableHttpClient;
import com.huawei.shade.org.apache.http.impl.client.HttpClients;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;

public class ServerlessRestClient {
    private static CloseableHttpClient client = null;
    private static final String ERROR_MSG = "error_msg";
    private static final String TRACE_ID = "traceId";
    private static final String AVAILABLE = "AVAILABLE";
    private static final String ACTIVE = "ACTIVE";

    public static void startServerless(Properties info) throws PSQLException {
        block14: {
            String traceId = null;
            try {
                String reqPath = "https://%s/v1/%s/clusters/%s/start";
                String endpoint = PGProperty.ENDPOINT.get(info);
                String projectId = PGProperty.PROJECT_ID.get(info);
                String clusterId = PGProperty.CLUSTER_ID.get(info);
                String ak = PGProperty.ACCESS_KEY_ID.get(info);
                String sk = PGProperty.SECRET_ACCESS_KEY.get(info);
                if (endpoint == null || projectId == null || clusterId == null || ak == null || sk == null) {
                    throw new PSQLException(GT.tr("Please confirm that all the parameters needed is added to the url.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                reqPath = String.format(reqPath, endpoint, projectId, clusterId);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("is_cluster_mode", (Object)"true");
                String stringParam = jsonObject.toString();
                HttpRequestBase httpRequestBase = ServerlessRestClient.createSignRequest(reqPath, stringParam, info, HttpMethodName.POST);
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).useTLS().build();
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)new AllowAllHostnameVerifier());
                client = HttpClients.custom().setSSLSocketFactory(sslSocketFactory).build();
                CloseableHttpResponse response = client.execute(httpRequestBase);
                int statusCode = response.getStatusLine().getStatusCode();
                String responseBody = ServerlessRestClient.convertStreamToString(response.getEntity().getContent());
                if (statusCode >= 200 && statusCode < 300) break block14;
                Header[] traceIds = response.getHeaders(TRACE_ID);
                if (traceIds != null && traceIds.length > 0) {
                    traceId = traceIds[0].getValue();
                }
                String errorMsg = null;
                try {
                    JSONObject jsonBody = JSONObject.parseObject(responseBody);
                    errorMsg = jsonBody.getString(ERROR_MSG);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new PSQLException(GT.tr("tranceId: {0} {1}", traceId, errorMsg), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
            }
            catch (Exception e) {
                throw new PSQLException(GT.tr("Start serverless failed. {0}", e.getMessage()), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)e);
            }
            finally {
                try {
                    if (client != null) {
                        client.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean checkClusterStatus(Properties info) throws PSQLException {
        String traceId = null;
        try {
            String reqPath = "https://%s/v1.0/%s/clusters/%s";
            String endpoint = PGProperty.ENDPOINT.get(info);
            String projectId = PGProperty.PROJECT_ID.get(info);
            String clusterId = PGProperty.CLUSTER_ID.get(info);
            String ak = PGProperty.ACCESS_KEY_ID.get(info);
            String sk = PGProperty.SECRET_ACCESS_KEY.get(info);
            if (endpoint == null || projectId == null || clusterId == null || ak == null || sk == null) {
                throw new PSQLException(GT.tr("Please confirm that all the parameters needed is added to the url.", new Object[0]), PSQLState.CONNECTION_REJECTED);
            }
            reqPath = String.format(reqPath, endpoint, projectId, clusterId);
            HttpRequestBase httpRequestBase = ServerlessRestClient.createSignRequest(reqPath, null, info, HttpMethodName.GET);
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).useTLS().build();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)new AllowAllHostnameVerifier());
            client = HttpClients.custom().setSSLSocketFactory(sslSocketFactory).build();
            CloseableHttpResponse response = client.execute(httpRequestBase);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseBody = ServerlessRestClient.convertStreamToString(response.getEntity().getContent());
            if (statusCode < 200 || statusCode >= 300) {
                Header[] traceIds = response.getHeaders(TRACE_ID);
                if (traceIds != null && traceIds.length > 0) {
                    traceId = traceIds[0].getValue();
                }
                String errorMsg = null;
                try {
                    JSONObject jsonBody = JSONObject.parseObject(responseBody);
                    errorMsg = jsonBody.getString(ERROR_MSG);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new PSQLException(GT.tr("tranceId: {0} {1}", traceId, errorMsg), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
            }
            JSONObject jsonBody = JSONObject.parseObject(responseBody);
            String status = jsonBody.getJSONObject("cluster").getString("status");
            if (ACTIVE.equals(status) || AVAILABLE.equals(status)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("Start serverless failed. {0}", e.getMessage()), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)e);
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static HttpRequestBase createSignRequest(String reqPath, String jsonParam, Properties info, HttpMethodName httpMethod) throws MalformedURLException, URISyntaxException, UnsupportedEncodingException {
        String ak = PGProperty.ACCESS_KEY_ID.get(info);
        String sk = PGProperty.SECRET_ACCESS_KEY.get(info);
        String regionName = PGProperty.REGION_NAME.get(info);
        String securityToken = PGProperty.SECURITY_TOKEN.get(info);
        URL url = new URL(reqPath);
        DefaultRequest request = new DefaultRequest("dws");
        request.setEndpoint(url.toURI());
        request.setHttpMethod(httpMethod);
        if (null != jsonParam) {
            byte[] bytes = jsonParam.getBytes();
            ByteArrayInputStream ins = new ByteArrayInputStream(bytes);
            request.setContent(ins);
        }
        Signer signer = SignerFactory.getSigner("dws", regionName);
        signer.sign(request, new BasicCredentials(ak, sk));
        HttpRequestBase httpRequestBase = ServerlessRestClient.createRequest(url, null, jsonParam, httpMethod);
        Map<String, String> requestHeaders = request.getHeaders();
        for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length".toString())) continue;
            httpRequestBase.addHeader(entry.getKey(), entry.getValue());
        }
        httpRequestBase.addHeader("X-Language", "en-us");
        httpRequestBase.addHeader("Content-Type", "application/json");
        httpRequestBase.addHeader("Accept", "application/json");
        if (null != securityToken) {
            httpRequestBase.addHeader("X-Security-Token", securityToken);
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).build();
        httpRequestBase.setConfig(requestConfig);
        return httpRequestBase;
    }

    private static HttpRequestBase createRequest(URL url, Header header, String param, HttpMethodName httpMethod) throws UnsupportedEncodingException {
        if (HttpMethodName.POST.equals((Object)httpMethod)) {
            HttpPost httpPost = new HttpPost(url.toString());
            StringEntity stringEntity = new StringEntity(param);
            httpPost.setEntity(stringEntity);
            httpPost.addHeader(header);
            return httpPost;
        }
        HttpGet httpGet = new HttpGet(url.toString());
        httpGet.addHeader(header);
        return httpGet;
    }

    private static String convertStreamToString(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException ioEX) {
            throw ioEX;
        }
        finally {
            is.close();
        }
        return sb.toString();
    }
}

