/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.sdk.internal.config;

import com.huawei.shade.com.cloud.sdk.internal.config.InternalConfigJsonHelper;
import com.huawei.shade.com.cloud.sdk.internal.config.JsonIndex;
import com.huawei.shade.com.cloud.sdk.internal.config.SignerConfig;
import com.huawei.shade.com.cloud.sdk.internal.config.SignerConfigJsonHelper;
import com.huawei.shade.com.cloud.sdk.util.ClassLoaderHelper;
import com.huawei.shade.com.cloud.sdk.util.json.Jackson;
import com.huawei.shade.com.fasterxml.jackson.databind.JsonMappingException;
import com.huawei.shade.org.apache.commons.logging.Log;
import com.huawei.shade.org.apache.commons.logging.LogFactory;
import com.huawei.shade.org.apache.http.annotation.Immutable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Immutable
public class InternalConfig {
    private static final Log log = LogFactory.getLog(InternalConfig.class);
    static final String DEFAULT_CONFIG_RESOURCE = "sdk_config_default.json";
    static final String CONFIG_OVERRIDE_RESOURCE = "sdk_config_override.json";
    private static final String SERVICE_REGION_DELIMITER = "/";
    private final SignerConfig defaultSignerConfig;
    private final Map<String, SignerConfig> serviceRegionSigners;
    private final Map<String, SignerConfig> regionSigners;
    private final Map<String, SignerConfig> serviceSigners;

    InternalConfig(InternalConfigJsonHelper defaults, InternalConfigJsonHelper override) {
        SignerConfigJsonHelper scb = defaults.getDefaultSigner();
        this.defaultSignerConfig = scb == null ? null : scb.build();
        this.regionSigners = this.mergeSignerMap(defaults.getRegionSigners(), override.getRegionSigners(), "region");
        this.serviceSigners = this.mergeSignerMap(defaults.getServiceSigners(), override.getServiceSigners(), "service");
        this.serviceRegionSigners = this.mergeSignerMap(defaults.getServiceRegionSigners(), override.getServiceRegionSigners(), "service/region");
    }

    private Map<String, SignerConfig> mergeSignerMap(JsonIndex<SignerConfigJsonHelper, SignerConfig>[] defaults, JsonIndex<SignerConfigJsonHelper, SignerConfig>[] overrides, String theme) {
        Map<String, SignerConfig> map = this.buildSignerMap(defaults, theme);
        Map<String, SignerConfig> mapOverride = this.buildSignerMap(overrides, theme);
        map.putAll(mapOverride);
        return Collections.unmodifiableMap(map);
    }

    private Map<String, SignerConfig> buildSignerMap(JsonIndex<SignerConfigJsonHelper, SignerConfig>[] signerIndexes, String theme) {
        HashMap<String, SignerConfig> map = new HashMap<String, SignerConfig>();
        if (signerIndexes != null) {
            for (JsonIndex<SignerConfigJsonHelper, SignerConfig> index : signerIndexes) {
                String region = index.getKey();
                SignerConfig prev = map.put(region, index.newReadOnlyConfig());
                if (prev == null) continue;
                log.warn("Duplicate definition of signer for " + theme + " " + index.getKey());
            }
        }
        return map;
    }

    public SignerConfig getSignerConfig(String serviceName) {
        return this.getSignerConfig(serviceName, null);
    }

    public SignerConfig getSignerConfig(String serviceName, String regionName) {
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        SignerConfig signerConfig = null;
        if (regionName != null) {
            String key = serviceName + SERVICE_REGION_DELIMITER + regionName;
            signerConfig = this.serviceRegionSigners.get(key);
            if (signerConfig != null) {
                return signerConfig;
            }
            signerConfig = this.regionSigners.get(regionName);
            if (signerConfig != null) {
                return signerConfig;
            }
        }
        return (signerConfig = this.serviceSigners.get(serviceName)) == null ? this.defaultSignerConfig : signerConfig;
    }

    static InternalConfigJsonHelper loadfrom(URL url) throws IOException, JsonMappingException {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        InternalConfigJsonHelper target = Jackson.getObjectMapper().readValue(url, InternalConfigJsonHelper.class);
        return target;
    }

    static InternalConfig load() throws IOException, JsonMappingException {
        InternalConfigJsonHelper configOverride;
        URL url = ClassLoaderHelper.getResource(File.separator + DEFAULT_CONFIG_RESOURCE, InternalConfig.class);
        if (url == null) {
            url = ClassLoaderHelper.getResource(DEFAULT_CONFIG_RESOURCE, InternalConfig.class);
        }
        InternalConfigJsonHelper config = InternalConfig.loadfrom(url);
        URL overrideUrl = ClassLoaderHelper.getResource(File.separator + CONFIG_OVERRIDE_RESOURCE, InternalConfig.class);
        if (overrideUrl == null) {
            overrideUrl = ClassLoaderHelper.getResource(CONFIG_OVERRIDE_RESOURCE, InternalConfig.class);
        }
        if (overrideUrl == null) {
            log.debug("Configuration override sdk_config_override.json not found.");
            configOverride = new InternalConfigJsonHelper();
        } else {
            configOverride = InternalConfig.loadfrom(overrideUrl);
        }
        return new InternalConfig(config, configOverride);
    }

    void dump() {
        StringBuilder sb = new StringBuilder().append("defaultSignerConfig: ").append(this.defaultSignerConfig).append("\n").append("serviceRegionSigners: ").append(this.serviceRegionSigners).append("\n").append("regionSigners: ").append(this.regionSigners).append("\n").append("serviceSigners: ").append(this.serviceSigners);
        log.debug(sb.toString());
    }

    public static class Factory {
        private static final InternalConfig SINGLETON;

        public static InternalConfig getInternalConfig() {
            return SINGLETON;
        }

        static {
            InternalConfig config;
            try {
                config = InternalConfig.load();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Fatal: Failed to load the internal config for Java SDK", ex);
            }
            SINGLETON = config;
        }
    }
}

