/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.converters;

import com.huawei.cloud.profiler.pap.v1.PDebuggerRequest;
import com.huawei.cloud.profiler.pap.v1.PDebuggerResponse;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.integration.debugger.converters.ArthasModelToPDebuggerConverter;
import com.lubanops.apm.integration.debugger.converters.ArthasSerializationHelper;
import com.taobao.arthas.core.command.model.VmToolModel;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.TypeRenderUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VmToolModelToPDebuggerResponseConverter
extends ArthasModelToPDebuggerConverter {
    private static final Logger logger = LogFactory.getLogger();

    public static PDebuggerResponse convertToList(VmToolModel vmToolModel, PDebuggerRequest request) {
        PDebuggerResponse.InstancesResponse instancesResponse = VmToolModelToPDebuggerResponseConverter.createInstancesResponse(vmToolModel);
        PDebuggerResponse.Payload.Builder payloadBuilder = PDebuggerResponse.Payload.newBuilder().setInstancesResponse(instancesResponse);
        return VmToolModelToPDebuggerResponseConverter.buildPDebuggerResponse(payloadBuilder, request.getPayload().getPayloadMetadata(), request.getMetadata());
    }

    private static PDebuggerResponse.InstancesResponse createInstancesResponse(VmToolModel vmToolModel) {
        ArrayList<PDebuggerResponse.InstancesResponse.SingleInstance> singleInstancesList = new ArrayList<PDebuggerResponse.InstancesResponse.SingleInstance>();
        List<Object> instances = Arrays.asList((Object[])vmToolModel.getValue().getObject());
        for (Object instance : instances) {
            PDebuggerResponse.InstancesResponse.SingleInstance singleInstance = PDebuggerResponse.InstancesResponse.SingleInstance.newBuilder().setType(instance.getClass().getName()).setValue(instance.getClass().getName() + "@" + instance.hashCode()).build();
            singleInstancesList.add(singleInstance);
        }
        return PDebuggerResponse.InstancesResponse.newBuilder().addAllValue(singleInstancesList).build();
    }

    public static PDebuggerResponse convert(VmToolModel result, PDebuggerRequest request) {
        Object instance = result.getValue().getObject();
        PDebuggerResponse.ObjectResponse objectResponse = PDebuggerResponse.ObjectResponse.newBuilder().setType(instance.getClass().getTypeName()).addAllFields(VmToolModelToPDebuggerResponseConverter.fetchInstanceFields(instance)).build();
        PDebuggerResponse.Payload.Builder payloadBuilder = PDebuggerResponse.Payload.newBuilder().setObjectResponse(objectResponse);
        return VmToolModelToPDebuggerResponseConverter.buildPDebuggerResponse(payloadBuilder, request.getPayload().getPayloadMetadata(), request.getMetadata());
    }

    public static Iterable<PDebuggerResponse.FieldVO> fetchInstanceFields(Object instance) {
        ArrayList<PDebuggerResponse.FieldVO> fields = new ArrayList<PDebuggerResponse.FieldVO>();
        for (Field field : instance.getClass().getDeclaredFields()) {
            VmToolModelToPDebuggerResponseConverter.withFieldGrantedAccess(field, () -> {
                try {
                    boolean isStatic = false;
                    if (Modifier.isStatic(field.getModifiers())) {
                        isStatic = true;
                    }
                    String[] annotations = TypeRenderUtils.getAnnotations((Annotation[])field.getAnnotations());
                    PDebuggerResponse.FieldVO fieldVO = PDebuggerResponse.FieldVO.newBuilder().setName(field.getName()).setType(field.getType().getTypeName()).setModifier(StringUtils.modifier((int)field.getModifiers(), (char)',')).setValue(VmToolModelToPDebuggerResponseConverter.getValue(instance, field)).setIsStatic(isStatic).addAllAnnotations(Arrays.asList(annotations)).build();
                    fields.add(fieldVO);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to serialize field");
                    e.printStackTrace();
                }
            });
        }
        return fields;
    }

    private static void withFieldGrantedAccess(Field field, Runnable codeBlock) {
        boolean isAccessibleStatus = field.isAccessible();
        try {
            if (!isAccessibleStatus) {
                field.setAccessible(true);
            }
            codeBlock.run();
        }
        finally {
            if (!isAccessibleStatus) {
                field.setAccessible(false);
            }
        }
    }

    private static String getValue(Object instance, Field field) throws IllegalAccessException {
        if (field.getType().getTypeName().equals("java.util.List") || List.class.isAssignableFrom(field.getType().getClass())) {
            List list = (List)field.get(instance);
            return org.apache.commons.lang3.StringUtils.join(list.subList(0, Math.min(list.size(), 100)), (String)", ");
        }
        return String.valueOf(field.get(instance));
    }

    private static String convertObject(String jpath, Object object, int depth, int maxIterableElements, int maxStringLength) {
        ArthasSerializationHelper serializer = new ArthasSerializationHelper();
        return serializer.serializeObject(jpath, object, depth, maxIterableElements, maxStringLength);
    }

    public static PDebuggerResponse convertInstance(VmToolModel arthasModel, PDebuggerRequest request, int maxDepth, int maxIterableElements, int maxStringLength) {
        Object instance = arthasModel.getValue().getObject();
        String instanceAsJson = VmToolModelToPDebuggerResponseConverter.convertObject("data.result", instance, maxDepth, maxIterableElements, maxStringLength);
        PDebuggerResponse.InstanceResponse protoInstance = PDebuggerResponse.InstanceResponse.newBuilder().setResult(instanceAsJson).build();
        PDebuggerResponse.Payload.Builder payloadBuilder = PDebuggerResponse.Payload.newBuilder().setInstanceResponse(protoInstance);
        return VmToolModelToPDebuggerResponseConverter.buildPDebuggerResponse(payloadBuilder, request.getPayload().getPayloadMetadata(), request.getMetadata());
    }
}

