/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mysql5.interceptor;

import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.mysql.jdbc.MultiHostMySQLConnection;
import com.mysql.jdbc.StatementImpl;
import java.sql.Connection;
import java.sql.SQLException;

public class PreparedStatementInteceptor {
    public static void onStart(String sql, Integer connectionId) {
        try {
            if (connectionId != null) {
                MysqlCollector.onConnectionStart((Integer)connectionId, (String)sql);
            }
            MysqlCollector.onStart((String)sql, (Integer)connectionId);
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
        }
    }

    public static void onError(String sql, Throwable e) {
        try {
            MysqlCollector.onConnectionException((Throwable)e, (String)sql);
            MysqlCollector.onThrowable((Throwable)e);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static Integer getConnectionId(StatementImpl statement) throws SQLException {
        try {
            Connection connection = statement.getConnection();
            try {
                Class.forName("com.mysql.jdbc.MultiHostMySQLConnection");
                if (connection instanceof MultiHostMySQLConnection) {
                    connection = ((MultiHostMySQLConnection)connection).getActiveMySQLConnection();
                }
            }
            catch (ClassNotFoundException e) {
                LogFactory.getLogger().log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
            if (connection != null && connection instanceof TransformAccess) {
                Integer id = (Integer)((TransformAccess)connection).getLopsAttribute();
                return id;
            }
        }
        catch (Exception mariaDBex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)mariaDBex);
        }
        return null;
    }
}

