/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mysql5.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlTrace;
import com.lubanops.apm.plugin.mysql5.interceptor.PreparedStatementInteceptor;
import com.lubanops.apm.plugin.mysql5.utils.Mysql5Utils;
import com.mysql.jdbc.ResultSetImpl;
import com.mysql.jdbc.StatementImpl;
import java.sql.SQLException;

public class StatementExecuteInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable() && !Mysql5Utils.isConnecting()) {
                StatementImpl statement = (StatementImpl)object;
                String originsql = (String)args[0];
                Integer id = PreparedStatementInteceptor.getConnectionId(statement);
                PreparedStatementInteceptor.onStart(originsql, id);
                MysqlTrace.onStart((String)className, (String)methodName, (String)originsql, (String)originsql, (Integer)id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                String sql = (String)args[0];
                PreparedStatementInteceptor.onError(sql, e);
                MysqlTrace.onError((Throwable)e);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        block7: {
            try {
                if (!MysqlCollector.INSTANCE.isEnable() || Mysql5Utils.isConnecting()) break block7;
                StatementImpl statement = (StatementImpl)object;
                String sql = (String)args[0];
                int updatedRowCount = 0;
                int readRowCount = 0;
                ResultSetImpl resultSetData = null;
                try {
                    updatedRowCount = statement.getUpdateCount();
                    resultSetData = (ResultSetImpl)statement.getResultSet();
                    if (resultSetData != null) {
                        readRowCount = Integer.valueOf(String.valueOf(resultSetData.getUpdateCount()));
                    }
                }
                catch (SQLException ex) {
                    LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
                }
                MysqlCollector.onFinally((int)updatedRowCount, (int)readRowCount);
                if (resultSetData != null && resultSetData instanceof TransformAccess) {
                    MysqlTrace.onFinally((int)updatedRowCount, (int)readRowCount, (TransformAccess)((TransformAccess)resultSetData));
                } else {
                    MysqlTrace.onFinally((int)updatedRowCount, (int)readRowCount, null);
                }
                MysqlCollector.onConnectionEnd((String)sql, (int)updatedRowCount, (int)readRowCount);
            }
            catch (Exception ex) {
                LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
            }
        }
    }
}

