/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.consumer.collector;

import com.lubanops.apm.bootstrap.plugin.common.url.UrlAggregator;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.rocketmq.consumer.stats.RocketMqConsumeStats;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class RocketMqConsumeListenerAggregator
extends UrlAggregator<RocketMqConsumeStats> {
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private final ThreadLocal<RocketMqConsumeStats> statsLocal = new ThreadLocal();

    public void parseParameters(Map<String, String> parameters) {
    }

    public void incrementConsumedMsgCount(int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementConsumedMsgCount(count);
        }
    }

    public void incrementConsumedBytesCount(int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementConsumedBytesCount(count);
        }
    }

    public void incrementReconsumeTimes(int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementReconsumeTimes(count);
        }
    }

    public void onStart(String identifier) {
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = (RocketMqConsumeStats)this.getValue(new String[]{identifier});
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onError(errorTraceId);
        }
    }

    public void onFinally() {
        long timeUsed;
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null && stats.onFinally(timeUsed = System.nanoTime() - startTime)) {
            stats.setSlowTraceId(TraceCollector.getTraceId());
        }
        this.statsLocal.remove();
        this.startTimeLocal.remove();
    }

    protected Class<RocketMqConsumeStats> getValueType() {
        return RocketMqConsumeStats.class;
    }

    protected List<String> primaryKey() {
        return Arrays.asList("consumeListener");
    }

    protected int primaryKeyLength() {
        return 1;
    }

    public String getUrlKey() {
        return "consumeListener";
    }

    public String getName() {
        return "consumeListener";
    }
}

