/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.consumer.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.rocketmq.RocketMqContext;
import com.lubanops.apm.plugin.rocketmq.RocketMqUtils;
import com.lubanops.apm.plugin.rocketmq.consumer.collector.RocketMqConsumerCollector;
import java.util.List;
import org.apache.rocketmq.client.consumer.DefaultLitePullConsumer;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.PullStatus;
import org.apache.rocketmq.client.impl.consumer.DefaultLitePullConsumerImpl;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPullConsumerImpl;
import org.apache.rocketmq.common.message.MessageQueue;

public class SyncPullInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (RocketMqConsumerCollector.INSTANCE.isEnable()) {
                DefaultLitePullConsumer consumer;
                DefaultLitePullConsumerImpl consumerImpl;
                String clientId = "unknown";
                String group = "unknown";
                String nameserver = "unknown";
                if (object instanceof DefaultLitePullConsumerImpl) {
                    consumerImpl = (DefaultLitePullConsumerImpl)object;
                    consumer = (DefaultLitePullConsumer)((AttributeAccess)consumerImpl).getLopsFileds()[0];
                    clientId = RocketMqUtils.getClientId(consumerImpl);
                    group = consumer.getConsumerGroup();
                    nameserver = consumer.getNamesrvAddr();
                } else if (object instanceof DefaultMQPullConsumerImpl) {
                    consumerImpl = (DefaultMQPullConsumerImpl)object;
                    consumer = (DefaultMQPullConsumer)((AttributeAccess)consumerImpl).getLopsFileds()[0];
                    clientId = RocketMqUtils.getClientId((DefaultMQPullConsumerImpl)consumerImpl);
                    group = consumer.getConsumerGroup();
                    nameserver = consumer.getNamesrvAddr();
                }
                RocketMqContext.NAMESERVER_LOCAL.set(nameserver);
                MessageQueue mq = (MessageQueue)args[0];
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"RocketMqConsumer");
                if (spanEvent != null) {
                    spanEvent.addTag("topic", mq.getTopic());
                    spanEvent.addTag("brokerName", mq.getBrokerName());
                    spanEvent.addTag("queueId", String.valueOf(mq.getQueueId()));
                }
                RocketMqConsumerCollector.onPullStart(clientId, group, mq);
            }
        }
        catch (Exception rocketMqPullException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rocketMqPullException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (RocketMqConsumerCollector.INSTANCE.isEnable()) {
                RocketMqConsumerCollector.onException(e);
                RocketMqConsumerCollector.onPullError(TraceCollector.getTraceId());
                TraceCollector.onError((Throwable)e);
                this.hasErrorLocal.set(Boolean.TRUE);
            }
        }
        catch (Exception rocketMqPullException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rocketMqPullException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (RocketMqConsumerCollector.INSTANCE.isEnable()) {
                boolean isFoundFailed = false;
                if (Boolean.TRUE.equals(this.hasErrorLocal.get())) {
                    isFoundFailed = true;
                }
                PullResult pullResult = (PullResult)result;
                int msgCount = 0;
                int msgBytes = 0;
                if (pullResult != null) {
                    PullStatus pullStatus = pullResult.getPullStatus();
                    if (!PullStatus.FOUND.equals((Object)pullStatus)) {
                        isFoundFailed = true;
                    }
                    List msgList = pullResult.getMsgFoundList();
                    msgCount = RocketMqUtils.getMsgCount(msgList);
                    msgBytes = RocketMqUtils.getMsgBytes(msgList);
                    SpanEvent spanEvent = TraceCollector.getSpanEvent();
                    if (spanEvent != null) {
                        spanEvent.addTag("status", pullStatus.name());
                        spanEvent.addTag("msgCount", String.valueOf(msgCount));
                        spanEvent.addTag("msgBytes", String.valueOf(msgBytes));
                    }
                }
                RocketMqConsumerCollector.onPullFinally(msgCount, msgBytes, isFoundFailed);
                TraceCollector.onFinally();
                this.hasErrorLocal.remove();
                RocketMqContext.NAMESERVER_LOCAL.remove();
            }
        }
        catch (Exception rocketMqPullException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rocketMqPullException);
        }
    }
}

