/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.elasticsearch.restclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.elasticsearch.restclient.collector.EsRestClientCollector;
import com.lubanops.apm.plugin.elasticsearch.restclient.stats.EsClientStats;
import org.elasticsearch.client.ResponseException;

public class AsyncResponseListenerOnFailureInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (EsRestClientCollector.INSTANCE.isEnable() && args[0] instanceof Exception) {
                SpanEvent spanEvent = (SpanEvent)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"spanEvent");
                EsClientStats stats = (EsClientStats)((Object)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"stats"));
                Long startTime = (Long)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"startTime");
                Exception exception = (Exception)args[0];
                if (!methodName.equals("trackFailure") || !(args[0] instanceof ResponseException)) {
                    EsRestClientCollector.onException(exception);
                }
                if (methodName.equals("onDefinitiveFailure")) {
                    if (stats != null) {
                        TraceCollector.onError((Throwable)exception);
                        EsRestClientCollector.onDefinitiveFailureAsync(stats, spanEvent == null ? null : spanEvent.getTraceId());
                        if (startTime != null) {
                            EsRestClientCollector.onResponseCloseAsync(startTime, stats, spanEvent == null ? null : spanEvent.getTraceId());
                        }
                    }
                    if (spanEvent != null) {
                        spanEvent.setSpanError(true);
                    }
                } else if (methodName.equals("trackFailure") && stats != null) {
                    EsRestClientCollector.onTrackFailureAsync(stats);
                }
                if (spanEvent != null) {
                    String spanMethod = spanEvent.getMethod();
                    if (spanMethod.equals("performRequestOld")) {
                        spanEvent.setMethod("performRequest");
                    }
                    TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
                }
            }
        }
        catch (Exception onFailureException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)onFailureException);
        }
    }
}

