/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cloud.profiler.commons.pap.v1.converters;

import com.google.protobuf.CodedInputStream;
import com.huawei.cloud.profiler.commons.pap.v1.converters.AbstractPDataConverter;
import com.huawei.cloud.profiler.commons.pap.v1.converters.ProtobufException;
import com.huawei.cloud.profiler.pap.v1.PData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class PDataCompressedStreamConverterImpl
extends AbstractPDataConverter {
    @Override
    public PData read(byte[] byteStream) {
        PData pData;
        GZIPInputStream inStream = new GZIPInputStream(new ByteArrayInputStream(byteStream));
        try {
            CodedInputStream input = CodedInputStream.newInstance((InputStream)inStream);
            pData = this.processInputStream(input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ProtobufException("Failed to read a compressed protobuf message", ex);
            }
        }
        ((InputStream)inStream).close();
        return pData;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] write(PData data) {
        try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream outputStream = new GZIPOutputStream(result);){
                outputStream.write(data.toByteArray());
                byArray = result.toByteArray();
            }
            return byArray;
        }
        catch (IOException ex) {
            throw new ProtobufException("Failed to write a compressed protobuf message", ex);
        }
    }
}

