/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cloud.profiler.commons.protocol.bindings;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Message;
import com.huawei.cloud.profiler.commons.protocol.bindings.MultiplexingDataProvider;
import com.huawei.cloud.profiler.commons.protocol.bindings.json.Encoding;
import com.huawei.cloud.profiler.commons.protocol.bindings.json.Multiplexing;
import com.huawei.cloud.profiler.commons.protocol.bindings.json.MultiplexingGroup;
import com.huawei.cloud.profiler.commons.protocol.bindings.json.MultiplexingGroupName;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.io.Resource;

public class MultiplexingDataJsonResourceProviderImpl
implements MultiplexingDataProvider {
    private final ObjectMapper objectMapper;
    private final Resource jsonResource;
    private final Map<MultiplexingGroupName, MultiplexingGroupOptimizedData> multiplexingInternalAssociation;
    private final Map<Class<? extends Message>, MultiplexingGroupName> typeToMultiplexingGroupAssociation;

    public MultiplexingDataJsonResourceProviderImpl(ObjectMapper objectMapper, Resource jsonResource) {
        this.objectMapper = objectMapper;
        this.jsonResource = jsonResource;
        this.multiplexingInternalAssociation = new HashMap<MultiplexingGroupName, MultiplexingGroupOptimizedData>();
        this.typeToMultiplexingGroupAssociation = new HashMap<Class<? extends Message>, MultiplexingGroupName>();
    }

    @Override
    public void initialize() {
        Multiplexing multiplexingData = (Multiplexing)this.objectMapper.readValue(this.jsonResource.getURL(), Multiplexing.class);
        for (MultiplexingGroup group : multiplexingData.getMultiplexing()) {
            HashMap<Class<? extends Message>, Byte> currTypeToPrefix = new HashMap<Class<? extends Message>, Byte>();
            HashMap<Byte, Class<? extends Message>> currPrefixToType = new HashMap<Byte, Class<? extends Message>>();
            for (Encoding encoding : group.getEncoding()) {
                String className = encoding.getType();
                Class<?> resolvedType = Class.forName(String.format("%s.%s", group.getNamespace(), className));
                currTypeToPrefix.put(resolvedType, (byte)encoding.getCode());
                currPrefixToType.put((byte)encoding.getCode(), resolvedType);
                this.typeToMultiplexingGroupAssociation.put(resolvedType, group.getName());
            }
            this.multiplexingInternalAssociation.put(group.getName(), new MultiplexingGroupOptimizedData(currTypeToPrefix, currPrefixToType));
        }
    }

    @Override
    public byte getMultiplexingCode(MultiplexingGroupName groupName, Class<? extends Message> type) {
        return this.multiplexingInternalAssociation.get((Object)groupName).getTypeToPrefix().get(type);
    }

    @Override
    public Class<? extends Message> getMultiplexingMsgClass(MultiplexingGroupName group, Byte code) {
        return this.multiplexingInternalAssociation.get((Object)group).getPrefixToType().get(code);
    }

    @Override
    public Optional<MultiplexingGroupName> getMultiplexingGroupForMessageOfType(Class<? extends Message> type) {
        return Optional.ofNullable(this.typeToMultiplexingGroupAssociation.get(type));
    }

    private static final class MultiplexingGroupOptimizedData {
        private final Map<Class<? extends Message>, Byte> typeToPrefix;
        private final Map<Byte, Class<? extends Message>> prefixToType;

        public MultiplexingGroupOptimizedData(Map<Class<? extends Message>, Byte> typeToPrefix, Map<Byte, Class<? extends Message>> prefixToType) {
            this.typeToPrefix = typeToPrefix;
            this.prefixToType = prefixToType;
        }

        public Map<Class<? extends Message>, Byte> getTypeToPrefix() {
            return this.typeToPrefix;
        }

        public Map<Byte, Class<? extends Message>> getPrefixToType() {
            return this.prefixToType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiplexingGroupOptimizedData)) {
                return false;
            }
            MultiplexingGroupOptimizedData other = (MultiplexingGroupOptimizedData)o;
            Map<Class<? extends Message>, Byte> this$typeToPrefix = this.getTypeToPrefix();
            Map<Class<? extends Message>, Byte> other$typeToPrefix = other.getTypeToPrefix();
            if (this$typeToPrefix == null ? other$typeToPrefix != null : !((Object)this$typeToPrefix).equals(other$typeToPrefix)) {
                return false;
            }
            Map<Byte, Class<? extends Message>> this$prefixToType = this.getPrefixToType();
            Map<Byte, Class<? extends Message>> other$prefixToType = other.getPrefixToType();
            return !(this$prefixToType == null ? other$prefixToType != null : !((Object)this$prefixToType).equals(other$prefixToType));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Class<? extends Message>, Byte> $typeToPrefix = this.getTypeToPrefix();
            result = result * 59 + ($typeToPrefix == null ? 43 : ((Object)$typeToPrefix).hashCode());
            Map<Byte, Class<? extends Message>> $prefixToType = this.getPrefixToType();
            result = result * 59 + ($prefixToType == null ? 43 : ((Object)$prefixToType).hashCode());
            return result;
        }

        public String toString() {
            return "MultiplexingDataJsonResourceProviderImpl.MultiplexingGroupOptimizedData(typeToPrefix=" + this.getTypeToPrefix() + ", prefixToType=" + this.getPrefixToType() + ")";
        }
    }
}

