/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.method;

import com.lubanops.apm.bootstrap.NoneNamedListener;
import com.lubanops.apm.bootstrap.collector.CollectorManager;
import com.lubanops.apm.bootstrap.plugin.collector.method.JavaMethodCollector;
import com.lubanops.apm.bootstrap.plugin.collector.method.MethodPattern;
import com.lubanops.apm.bootstrap.plugin.method.interceptor.JavaMethodInterceptor;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class JavaMethodListener
implements NoneNamedListener {
    public void init() {
        CollectorManager.TAGS.add("JavaMethod");
        JavaMethodCollector.getInstance();
    }

    public List<String> matchClass(String className, byte[] classfileBuffer) {
        if (className == null) {
            return null;
        }
        if (className.startsWith("sun/") || className.startsWith("java/") || className.startsWith("javax/")) {
            return null;
        }
        if (className.startsWith("com/lubanops/apm/bootstrap") || className.startsWith("com/lubanops/apm/premain") || className.startsWith("com/lubanops/apm/transformer")) {
            return null;
        }
        if (className.contains("$")) {
            return null;
        }
        List<MethodPattern> methodPatterns = JavaMethodCollector.getInstance().getMethodPatterns();
        for (MethodPattern methodPattern : methodPatterns) {
            boolean isMatch = Pattern.matches(methodPattern.getClassName(), className);
            if (!isMatch) continue;
            String methods = methodPattern.getMethodNames();
            JavaMethodCollector.setNeedCount(className, methodPattern.isStatistics());
            if (!StringUtils.isBlank((String)methods)) {
                String[] methodArray = methods.split(",");
                return Arrays.asList(methodArray);
            }
            return new ArrayList<String>();
        }
        return null;
    }

    public String getInterceptor() {
        return JavaMethodInterceptor.class.getName();
    }

    public boolean hasAttribute() {
        return false;
    }

    public boolean appendBootstrapClassLoader() {
        return true;
    }
}

