/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.config;

import java.util.concurrent.atomic.AtomicInteger;

public class Stats {
    public static final Stats SLOW_DEFAULT = new Stats(80, 30, 10, 2);
    public static final Stats ERROR_DEFAULT = new Stats(80, 30, 10, 2);
    public static final Stats NORMAL_DEFAULT = new Stats(20, 10, 5, 1);
    public int lowCpuThreshold;
    public int midCpuThreshold;
    public int highCpuThreshold;
    public AtomicInteger sampleCount = new AtomicInteger(0);
    private static double cpuRatio = 0.0;
    public int minPerUrl;

    public Stats(int a, int b, int c, int d) {
        this.lowCpuThreshold = a;
        this.midCpuThreshold = b;
        this.highCpuThreshold = c;
        this.minPerUrl = d;
    }

    public static Stats parseValue(String s) {
        String[] ss = s.split(",");
        int a = Integer.parseInt(ss[0]);
        int b = Integer.parseInt(ss[1]);
        int c = Integer.parseInt(ss[2]);
        int d = Integer.parseInt(ss[3]);
        Stats stats = new Stats(a, b, c, d);
        return stats;
    }

    public int getMinPerUrl() {
        return this.minPerUrl;
    }

    public int getThreshold() {
        if (Stats.getCpuRatio() < 30.0) {
            return this.lowCpuThreshold;
        }
        if (Stats.getCpuRatio() < 60.0) {
            return this.midCpuThreshold;
        }
        return this.highCpuThreshold;
    }

    public static double getCpuRatio() {
        return cpuRatio;
    }

    public static void setCpuRatio(double cpuRatio) {
        Stats.cpuRatio = cpuRatio;
    }
}

