/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.otel;

import com.lubanops.apm.bootstrap.otel.SpanId;
import com.lubanops.apm.bootstrap.otel.TraceId;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;

public enum RandomIdGenerator {
    INSTANCE;

    private static final long INVALID_ID = 0L;
    private static final Supplier<Random> randomSupplier;

    public String generateSpanId() {
        long id;
        Random random = randomSupplier.get();
        while ((id = random.nextLong()) == 0L) {
        }
        return SpanId.fromLong(id);
    }

    public String generateTraceId() {
        long idLo;
        Random random = randomSupplier.get();
        long idHi = random.nextLong();
        while ((idLo = random.nextLong()) == 0L) {
        }
        return TraceId.fromLongs(idHi, idLo);
    }

    public String toString() {
        return "RandomIdGenerator{}";
    }

    static {
        randomSupplier = ThreadLocalRandom::current;
    }
}

