/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text;

import com.taobao.text.LineReader;
import com.taobao.text.RenderAppendable;
import java.util.Iterator;

public abstract class LineRenderer {
    public static final LineRenderer NULL = new LineRenderer(){

        @Override
        public int getActualWidth() {
            return 0;
        }

        @Override
        public int getMinWidth() {
            return 0;
        }

        @Override
        public int getMinHeight(int width) {
            return 0;
        }

        @Override
        public int getActualHeight(int width) {
            return 0;
        }

        @Override
        public LineReader reader(int width) {
            return new LineReader(){

                @Override
                public boolean hasLine() {
                    return false;
                }

                @Override
                public void renderLine(RenderAppendable to) throws IllegalStateException {
                    throw new IllegalStateException();
                }
            };
        }
    };

    public static LineRenderer vertical(Iterable<? extends LineRenderer> renderers) {
        Iterator<? extends LineRenderer> i = renderers.iterator();
        if (i.hasNext()) {
            LineRenderer renderer = i.next();
            if (i.hasNext()) {
                return new Composite(renderers);
            }
            return renderer;
        }
        return NULL;
    }

    public abstract int getActualWidth();

    public abstract int getMinWidth();

    public abstract int getMinHeight(int var1);

    public abstract int getActualHeight(int var1);

    public LineReader reader(int width, int height) {
        if (height > 0) {
            return null;
        }
        return this.reader(width);
    }

    public abstract LineReader reader(int var1);

    public final void render(RenderAppendable out) {
        LineReader renderer = this.reader(out.getWidth());
        if (renderer != null) {
            while (renderer.hasLine()) {
                renderer.renderLine(out);
                out.append('\n');
            }
        }
    }

    private static class Composite
    extends LineRenderer {
        private final Iterable<? extends LineRenderer> renderers;
        private final int actualWidth;
        private final int minWidth;

        private Composite(Iterable<? extends LineRenderer> renderers) {
            int actualWidth = 0;
            int minWidth = 0;
            for (LineRenderer lineRenderer : renderers) {
                actualWidth = Math.max(actualWidth, lineRenderer.getActualWidth());
                minWidth = Math.max(minWidth, lineRenderer.getMinWidth());
            }
            this.actualWidth = actualWidth;
            this.minWidth = minWidth;
            this.renderers = renderers;
        }

        @Override
        public int getActualWidth() {
            return this.actualWidth;
        }

        @Override
        public int getMinWidth() {
            return this.minWidth;
        }

        @Override
        public int getActualHeight(int width) {
            int actualHeight = 0;
            for (LineRenderer lineRenderer : this.renderers) {
                actualHeight += lineRenderer.getActualHeight(width);
            }
            return actualHeight;
        }

        @Override
        public int getMinHeight(int width) {
            return 1;
        }

        @Override
        public LineReader reader(final int width, final int height) {
            final Iterator<? extends LineRenderer> i = this.renderers.iterator();
            return new LineReader(){
                private LineReader current;
                private int index = 0;

                @Override
                public boolean hasLine() {
                    if (height > 0 && this.index >= height) {
                        return false;
                    }
                    if (this.current == null || !this.current.hasLine()) {
                        while (i.hasNext()) {
                            LineRenderer next = (LineRenderer)i.next();
                            LineReader reader = next.reader(width);
                            if (reader == null || !reader.hasLine()) continue;
                            this.current = reader;
                            return true;
                        }
                        return false;
                    }
                    return true;
                }

                @Override
                public void renderLine(RenderAppendable to) throws IllegalStateException {
                    if (this.hasLine()) {
                        this.current.renderLine(to);
                        ++this.index;
                    } else {
                        throw new IllegalStateException();
                    }
                }
            };
        }

        @Override
        public LineReader reader(int width) {
            return this.reader(width, -1);
        }
    }
}

