/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq;

import com.rabbitmq.client.impl.ChannelN;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RabbitChannelHolder {
    public static final ConcurrentHashMap<String, Set<ChannelN>> CHANNEL_HOLDER = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerChannel(String identifier, ChannelN channel) {
        Set<ChannelN> set;
        if (channel == null) {
            return;
        }
        if (!CHANNEL_HOLDER.containsKey(identifier) && CHANNEL_HOLDER.size() < 500) {
            ConcurrentHashMap<String, Set<ChannelN>> concurrentHashMap = CHANNEL_HOLDER;
            synchronized (concurrentHashMap) {
                if (!CHANNEL_HOLDER.containsKey(identifier)) {
                    CHANNEL_HOLDER.put(identifier, Collections.synchronizedSet(new HashSet()));
                }
            }
        }
        if ((set = CHANNEL_HOLDER.get(identifier)) != null && set.size() < 100) {
            set.add(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterChannel(String identifier, ChannelN channel) {
        Set<ChannelN> set;
        if (channel == null) {
            return;
        }
        if (CHANNEL_HOLDER.containsKey(identifier) && (set = CHANNEL_HOLDER.get(identifier)) != null) {
            set.remove(channel);
            if (set.size() == 0) {
                ConcurrentHashMap<String, Set<ChannelN>> concurrentHashMap = CHANNEL_HOLDER;
                synchronized (concurrentHashMap) {
                    set = CHANNEL_HOLDER.get(identifier);
                    if (set != null && set.size() == 0) {
                        CHANNEL_HOLDER.remove(identifier);
                    }
                }
            }
        }
    }

    public static void unregisterChannel(ChannelN channel) {
        for (String id : CHANNEL_HOLDER.keySet()) {
            RabbitChannelHolder.unregisterChannel(id, channel);
        }
    }
}

