/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.consumer.collector;

import com.lubanops.apm.bootstrap.plugin.common.url.UrlAggregator;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.rabbitmq.consumer.stats.RabbitMqPushConsumeInvokeStats;
import com.rabbitmq.client.impl.ChannelN;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RabbitMqPushConsumeAggregator
extends UrlAggregator<RabbitMqPushConsumeInvokeStats> {
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private final ThreadLocal<RabbitMqPushConsumeInvokeStats> statsLocal = new ThreadLocal();

    public void parseParameters(Map<String, String> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        String sampType = (String)ParameterParseUtil.getParameterValue(parameters, (String)"rabbitMqConsumerSampleType", String.class);
        String percentage = (String)ParameterParseUtil.getParameterValue(parameters, (String)"rabbitMqConsumerPercentage", String.class);
        String periodCount = (String)ParameterParseUtil.getParameterValue(parameters, (String)"rabbitMqConsumerPeriodCount", String.class);
        this.getSampleConfig().setPercentage(percentage);
        this.getSampleConfig().setPeriodCount(periodCount);
        this.getSampleConfig().setSampleType(sampType);
        Integer slowRequestThreshold = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"rabbitMqConsumerSlowRequestThreshold", Integer.class);
        this.setSlowRequestThreshold(slowRequestThreshold);
    }

    public void setMaxSingleMsgBytes(int bytesCount) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqPushConsumeInvokeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.setMaxSingleMsgBytes(bytesCount);
        }
    }

    public void incrementConsumedMsgCount() {
        if (!this.isEnable) {
            return;
        }
        RabbitMqPushConsumeInvokeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementConsumedMsgCount();
        }
    }

    public void incrementConsumedBytesCount(int count) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqPushConsumeInvokeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementConsumedBytesCount(count);
        }
    }

    public void incrementManualAckCount(int ackedMsgCount) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqPushConsumeInvokeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementManualAckCount(ackedMsgCount);
        }
    }

    public void incrementRejectCount(int rejectedMsgCount) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqPushConsumeInvokeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementRejectCount(rejectedMsgCount);
        }
    }

    public void incrementRequeueCount(int requeuedMsgCount) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqPushConsumeInvokeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementRequeueCount(requeuedMsgCount);
        }
    }

    public void onStart(String identifier, ChannelN channelN) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqPushConsumeInvokeStats stats = (RabbitMqPushConsumeInvokeStats)this.getValue(new String[]{identifier});
        if (stats.getConsumerIdentifier() == null) {
            stats.setConsumerIdentifier(identifier);
        }
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqPushConsumeInvokeStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onError(errorTraceId);
        }
    }

    public void onFinally() {
        long timeUsed;
        if (!this.isEnable) {
            return;
        }
        RabbitMqPushConsumeInvokeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null && stats.onFinally(timeUsed = System.nanoTime() - startTime)) {
            stats.setSlowTraceId(TraceCollector.getTraceId());
        }
        this.statsLocal.remove();
        this.startTimeLocal.remove();
    }

    protected Class<RabbitMqPushConsumeInvokeStats> getValueType() {
        return RabbitMqPushConsumeInvokeStats.class;
    }

    protected List<String> primaryKey() {
        return Arrays.asList("pushConsumeIdentifier");
    }

    protected int primaryKeyLength() {
        return 1;
    }

    public String getUrlKey() {
        return "pushConsumeIdentifier";
    }

    public String getName() {
        return "pushConsume";
    }
}

