/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.gaussdb.zenith.interceptor;

import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.plugin.gaussdb.zenith.collector.GaussDbCollector;

public class ConnectionCloseInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            this.hasErrorLocal.set(Boolean.TRUE);
            GaussDbCollector.onThrowable(e);
        }
        catch (Exception connectionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)connectionException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            Integer id;
            GaussConnectionImpl connection = (GaussConnectionImpl)object;
            boolean hasError = Boolean.TRUE.equals(this.hasErrorLocal.get());
            if (!hasError && !connection.isClosed() && (id = (Integer)((TransformAccess)object).getLopsAttribute()) != null) {
                GaussDbCollector.onConnectionDestroyed(id);
            }
            this.hasErrorLocal.remove();
        }
        catch (Exception connectionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)connectionException);
        }
    }
}

