/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.utils;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.core.utils.AgentPath;
import com.lubanops.apm.integration.utils.APMThreadFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.LoaderClassPath;
import javassist.NotFoundException;

public class ClassPoolUtils {
    static ClassPool pool = null;
    static Set<ClassLoader> classLoaders = new HashSet<ClassLoader>();
    private static final Logger LOGGER = LogFactory.getLogger();

    public static void init() {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new APMThreadFactory("classpool"));
        scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ClassPoolUtils.clearClassPool();
            }
        }, 120L, 300L, TimeUnit.SECONDS);
    }

    public static ClassPool getClassPool(ClassLoader classLoader) {
        ClassPool pool = ClassPoolUtils.getClassPool();
        if (classLoader != null && !classLoaders.contains(classLoader)) {
            LoaderClassPath classPath = new LoaderClassPath(classLoader);
            pool.appendClassPath((ClassPath)classPath);
            classLoaders.add(classLoader);
        }
        return pool;
    }

    public static ClassPool getClassPool() {
        ClassPool classPool = pool;
        if (classPool == null) {
            classPool = new ClassPool(null);
            classPool.appendSystemPath();
            ClassPoolUtils.addBootJar(classPool, AgentPath.getInstance().getBootPath());
            ClassPoolUtils.addBootJar(classPool, AgentPath.getInstance().getPluginsPath());
            pool = classPool;
        }
        return classPool;
    }

    public static void clearClassPool() {
        classLoaders = new HashSet<ClassLoader>();
        pool = null;
    }

    public static void addBootJar(ClassPool pool, String bootPath) {
        File dir = new File(bootPath);
        File[] bootFiles = dir.listFiles();
        if (bootFiles != null) {
            for (File file : bootFiles) {
                try {
                    pool.appendClassPath(file.getCanonicalPath());
                }
                catch (NotFoundException e) {
                    LOGGER.log(Level.SEVERE, "getClassPool failed", (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "getClassPool failed", (Throwable)e);
                }
            }
        }
    }
}

