/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.offload;

import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.offload.GetAnswer;
import com.lubanops.apm.offload.OfferAnswer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.util.ByteArrayBuffer;

public class OffHeapCache {
    private static String cacheFilePefix = "cache";
    private static final int BUFFER_SIZE = 16384;
    private String cacheFile = null;
    private final int index;
    private ByteArrayBuffer bufferStr;
    private RandomAccessFile randomAccessFileWrite;
    RandomAccessFile randomAccessFileRead;
    private long FILE_SIZE = 0x100000L;
    private FileChannel fileChannelWrite;
    private FileChannel fileChannelRead;
    private MappedByteBuffer writeMappedByteBuffer;
    private static byte[] DELIMITER = "\n".getBytes();
    private MappedByteBuffer readMappedByteBuffer;
    long lastWrite = 0L;

    public OffHeapCache(int i_index) throws Exception {
        this.index = i_index;
        String appFolder = this.getAppFolderName();
        File folder = new File(AgentConfigManager.getOffHeapFileDir() + File.separator + appFolder + File.separator + "cache");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.cacheFile = folder.getAbsolutePath() + File.separator + cacheFilePefix + this.index;
        File file = new File(this.cacheFile);
        if (file.exists()) {
            file.delete();
        }
        this.randomAccessFileWrite = new RandomAccessFile(this.cacheFile, "rw");
        this.fileChannelWrite = this.randomAccessFileWrite.getChannel();
        this.randomAccessFileRead = new RandomAccessFile(this.cacheFile, "r");
        this.fileChannelRead = this.randomAccessFileRead.getChannel();
        this.bufferStr = new ByteArrayBuffer(16384);
        this.writeMappedByteBuffer = this.fileChannelWrite.map(FileChannel.MapMode.READ_WRITE, 0L, this.FILE_SIZE);
        this.readMappedByteBuffer = this.fileChannelRead.map(FileChannel.MapMode.READ_ONLY, 0L, this.FILE_SIZE);
    }

    public OffHeapCache init() {
        this.setLastAccess(System.currentTimeMillis());
        try {
            this.writeMappedByteBuffer = this.fileChannelWrite.map(FileChannel.MapMode.READ_WRITE, 0L, this.FILE_SIZE);
            this.readMappedByteBuffer = this.fileChannelRead.map(FileChannel.MapMode.READ_ONLY, 0L, this.FILE_SIZE);
        }
        catch (IOException e) {
            LogFactory.getLogger().severe("Failed to add file to cache");
            throw new RuntimeException(e);
        }
        return this;
    }

    public OfferAnswer offer(byte[] bytes) {
        OfferAnswer answer = new OfferAnswer();
        try {
            long nextPos = this.writeMappedByteBuffer.position() + bytes.length + DELIMITER.length;
            if (nextPos < this.FILE_SIZE) {
                this.writeMappedByteBuffer.put(bytes);
                this.writeMappedByteBuffer.put(DELIMITER);
                this.setLastAccess(System.currentTimeMillis());
            } else {
                answer.setStatus(false);
                answer.setNeedToWriteToNextCacheFile(true);
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().severe("Failed to write to cache " + this.index + " " + e.getMessage());
            answer.setStatus(false);
        }
        return answer;
    }

    public GetAnswer get() {
        this.setLastAccess(System.currentTimeMillis());
        GetAnswer getAnswer = new GetAnswer(false, false);
        while (this.readMappedByteBuffer.position() < this.writeMappedByteBuffer.position()) {
            char a = (char)this.readMappedByteBuffer.get();
            if (a == '\n') {
                getAnswer.setArr(ArrayUtils.toObject((byte[])this.bufferStr.toByteArray()));
                getAnswer.setStatus(true);
                break;
            }
            this.bufferStr.append((int)a);
        }
        if (this.readMappedByteBuffer.position() == this.writeMappedByteBuffer.position()) {
            getAnswer.setNeedToReadTFromNextCacheFile(true);
        }
        this.bufferStr.clear();
        return getAnswer;
    }

    public void setLastAccess(long lastWrite) {
        this.lastWrite = lastWrite;
    }

    public long size() {
        return this.writeMappedByteBuffer.position();
    }

    public boolean capacity() {
        return this.writeMappedByteBuffer.position() > this.readMappedByteBuffer.position();
    }

    public int index() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffHeapCache that = (OffHeapCache)o;
        if (this.index != that.index) {
            return false;
        }
        return this.cacheFile.equals(that.cacheFile);
    }

    public int hashCode() {
        int result = this.cacheFile.hashCode();
        result = 31 * result + this.index;
        return result;
    }

    private String getAppFolderName() {
        String combinedEnvName = IdentityConfigManager.getCombinedEnvName();
        String[] arr = combinedEnvName.split(":");
        if (arr.length == 3) {
            return arr[1] + "-" + arr[2];
        }
        return "";
    }
}

