/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.huawei.bsp.encrypt.cbb.impl;

import com.lubanops.huawei.bsp.encrypt.cbb.KeyException;
import com.lubanops.huawei.bsp.encrypt.cbb.impl.PBKDF2WithHmacSHA;
import java.security.Key;

public final class PBKDF2WithHmacSHA256 {
    public static final int KEYGEN_VERSION = 2;
    private static final String ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final int PHASH_ITERATION = 10000;
    private static final int PHASH_KEYLEN = 256;

    private PBKDF2WithHmacSHA256() {
    }

    public static Key generateKey(byte[] keymaterial, byte[] salt, int iteration, int keylen) throws KeyException {
        return PBKDF2WithHmacSHA.generateKey(ALGORITHM, keymaterial, salt, iteration, keylen);
    }

    public static byte[] passwordHash(char[] material, byte[] salt) throws KeyException {
        return PBKDF2WithHmacSHA.passwordHash(ALGORITHM, 10000, 256, material, salt);
    }
}

