/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mariadb3.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlTrace;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.mariadb3.interceptor.PreparedStatementInteceptor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mariadb.jdbc.client.result.Result;
import org.mariadb.jdbc.client.util.Parameter;
import org.mariadb.jdbc.client.util.Parameters;

public class PreparedStatementExecuteInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable() && object instanceof AttributeAccess) {
                PreparedStatement preparedStatement = (PreparedStatement)object;
                Object[] fields = ((AttributeAccess)object).getLopsFileds();
                String sql = this.getSql(fields);
                Integer id = PreparedStatementInteceptor.getConnectionId(preparedStatement);
                PreparedStatementInteceptor.onStart(sql, id);
                MysqlTrace.onStart((String)className, (String)methodName, (String)sql, null, (Integer)id);
                this.setOriginSql(fields);
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
        }
        return new Object[0];
    }

    private String getSql(Object[] fields) {
        return (String)fields[1];
    }

    private void setOriginSql(Object[] fields) {
        if (MysqlCollector.CONFIG.isParseOriginSql()) {
            String parameters;
            int parameterCountLimit = 20;
            StringBuilder parameter = new StringBuilder();
            int parameterCount = 0;
            if (fields[0] != null && fields[0] instanceof Parameters) {
                parameters = (Parameters)fields[0];
                for (int i = 0; i < parameters.size() && parameterCount <= parameterCountLimit; ++parameterCount, ++i) {
                    Parameter param = parameters.get(i);
                    if (parameterCount == 0) {
                        parameter.append(this.getValue(param));
                        continue;
                    }
                    parameter.append(",").append(this.getValue(param));
                }
            }
            if (!StringUtils.isBlank((String)(parameters = parameter.toString()))) {
                TraceCollector.addTag((String)"parameters", (String)parameters);
            }
        }
    }

    private String getValue(Parameter param) {
        Object[] fileds;
        if (param == null) {
            return "null";
        }
        if (param instanceof AttributeAccess && (fileds = ((AttributeAccess)param).getLopsFileds()) != null && fileds.length > 0) {
            Object filed = fileds[0];
            return String.valueOf(filed);
        }
        return "unknow";
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (object instanceof AttributeAccess) {
                Object[] fields = ((AttributeAccess)object).getLopsFileds();
                String sql = this.getSql(fields);
                PreparedStatementInteceptor.onError(e, sql);
                MysqlTrace.onError((Throwable)e);
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        block7: {
            try {
                if (!(object instanceof AttributeAccess)) break block7;
                Object[] fields = ((AttributeAccess)object).getLopsFileds();
                String sql = this.getSql(fields);
                PreparedStatement preparedStatement = (PreparedStatement)object;
                int updatedRowCount = 0;
                int readRowCount = 0;
                ResultSet resultSet = null;
                try {
                    updatedRowCount = preparedStatement.getUpdateCount();
                    resultSet = preparedStatement.getResultSet();
                    if (resultSet != null && resultSet instanceof Result) {
                        readRowCount = PreparedStatementInteceptor.getDataSize((Result)resultSet);
                    }
                }
                catch (SQLException e) {
                    LogFactory.getLogger().log(Level.SEVERE, "sql result error", (Throwable)e);
                }
                MysqlCollector.onFinally((int)updatedRowCount, (int)readRowCount);
                if (resultSet != null && resultSet instanceof TransformAccess) {
                    MysqlTrace.onFinally((int)updatedRowCount, (int)readRowCount, (TransformAccess)((TransformAccess)resultSet));
                } else {
                    MysqlTrace.onFinally((int)updatedRowCount, (int)readRowCount, null);
                }
                MysqlCollector.onConnectionEnd((String)sql, (int)updatedRowCount, (int)readRowCount);
            }
            catch (Exception e) {
                LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
            }
        }
    }
}

