/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.mqtt.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.plugin.mqtt.stats.MqttMsgInvocationStats;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PahoMsgInvocationAggregator
extends MultiPrimaryKeyAggregator<MqttMsgInvocationStats> {
    private static final String URI = "uri";
    private static final String MESSAGE_TYPE = "msgType";
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private final ThreadLocal<MqttMsgInvocationStats> statsLocal = new ThreadLocal();
    private final ThreadLocal<Boolean> errorLocal = new ThreadLocal();
    private final ThreadLocal<String> hostLocal = new ThreadLocal();

    public void parseParameters(Map<String, String> parameters) {
    }

    public void onStart(String uri, String msgType) {
        if (!this.isEnable) {
            return;
        }
        MqttMsgInvocationStats stats = (MqttMsgInvocationStats)this.getValue(new String[]{uri, msgType});
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
        this.hostLocal.set(uri);
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        MqttMsgInvocationStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onError(errorTraceId);
            this.errorLocal.set(Boolean.TRUE);
        }
    }

    public void onFinally(String traceId, String collectorName, boolean flowIn) {
        if (!this.isEnable) {
            return;
        }
        MqttMsgInvocationStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            String toAddr;
            String fromAddr;
            Boolean error;
            long timeUsed = System.nanoTime() - startTime;
            if (stats.onFinally(timeUsed)) {
                stats.setSlowTraceId(traceId);
            }
            if ((error = this.errorLocal.get()) == null) {
                error = Boolean.FALSE;
            }
            String host = this.hostLocal.get();
            if (flowIn) {
                fromAddr = this.getUriFromUriTopic(host);
                toAddr = String.valueOf(IdentityConfigManager.getEnvId());
            } else {
                fromAddr = String.valueOf(IdentityConfigManager.getEnvId());
                toAddr = this.getUriFromUriTopic(host);
            }
            TransactionCollector.collect((long)timeUsed, (boolean)error, (String)fromAddr, (String)toAddr, (List)TransactionCollector.getTxName(), (String)collectorName);
        }
        this.statsLocal.remove();
        this.startTimeLocal.remove();
        this.errorLocal.remove();
        this.hostLocal.remove();
    }

    public Map<String, Object> onStartAsync(String uri, String msgType) {
        if (!this.isEnable) {
            return null;
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        MqttMsgInvocationStats stats = (MqttMsgInvocationStats)this.getValue(new String[]{uri, msgType});
        if (stats != null) {
            long startTime = stats.onStart();
            res.put("stats", (Object)stats);
            res.put("startTime", startTime);
            res.put("host", uri);
            res.put("txName", TransactionCollector.getTxName());
            return res;
        }
        return null;
    }

    public void onErrorAsync(Map<String, Object> map) {
        if (!this.isEnable) {
            return;
        }
        MqttMsgInvocationStats stats = (MqttMsgInvocationStats)((Object)map.get("stats"));
        SpanEvent spanEvent = (SpanEvent)map.get("spanEvent");
        if (stats != null && spanEvent != null) {
            stats.onError();
            stats.onError(spanEvent.getTraceId());
        }
        map.put("error", Boolean.TRUE);
    }

    public void onFinallyAsync(Map<String, Object> map, String collectorName, boolean flowIn) {
        if (!this.isEnable) {
            return;
        }
        MqttMsgInvocationStats stats = (MqttMsgInvocationStats)((Object)map.get("stats"));
        Long startTime = (Long)map.get("startTime");
        SpanEvent spanEvent = (SpanEvent)map.get("spanEvent");
        if (stats != null && startTime != null) {
            String toAddr;
            String fromAddr;
            Boolean error;
            Long timeUsed = System.nanoTime() - startTime;
            if (stats.onFinally(timeUsed) && spanEvent != null) {
                stats.setSlowTraceId(spanEvent.getTraceId());
            }
            if ((error = (Boolean)map.get("error")) == null) {
                error = Boolean.FALSE;
            }
            String host = (String)map.get("host");
            List txName = (List)map.get("txName");
            if (flowIn) {
                fromAddr = this.getUriFromUriTopic(host);
                toAddr = String.valueOf(IdentityConfigManager.getEnvId());
            } else {
                fromAddr = String.valueOf(IdentityConfigManager.getEnvId());
                toAddr = this.getUriFromUriTopic(host);
            }
            TransactionCollector.collect((long)timeUsed, (boolean)error, (String)fromAddr, (String)toAddr, (List)txName, (String)collectorName);
        }
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
        ArrayList<MonitorDataRow> uriRowList = new ArrayList<MonitorDataRow>();
        HashMap<String, MonitorDataRow> uriMap = new HashMap<String, MonitorDataRow>();
        if (collected != null && !collected.isEmpty()) {
            for (MonitorDataRow row : collected) {
                String uri = this.getUriFromUriTopic((String)row.get((Object)URI));
                MonitorDataRow uriRow = (MonitorDataRow)uriMap.get(uri);
                if (uriRow == null) {
                    uriRow = new MonitorDataRow();
                    uriRow.put((Object)URI, (Object)uri);
                    uriMap.put(uri, uriRow);
                    uriRowList.add(uriRow);
                }
                this.addNewCount(uriRow, row, "invokeCount");
                this.addNewCount(uriRow, row, "totalTime");
                this.addNewCount(uriRow, row, "errorCount");
            }
        }
        res.put("uriMessage", uriRowList);
        return res;
    }

    private void addNewCount(MonitorDataRow row, MonitorDataRow rowToAdd, String key) {
        Long oldCount = (Long)row.get((Object)key);
        Long addCount = (Long)rowToAdd.get((Object)key);
        if (oldCount == null) {
            oldCount = 0L;
        }
        if (addCount == null) {
            addCount = 0L;
        }
        row.put((Object)key, (Object)(oldCount + addCount));
    }

    private String getUriFromUriTopic(String s) {
        return s.substring(0, s.indexOf(64));
    }

    protected Class<MqttMsgInvocationStats> getValueType() {
        return MqttMsgInvocationStats.class;
    }

    protected int primaryKeyLength() {
        return 2;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(URI, MESSAGE_TYPE);
    }

    public String getName() {
        return "message";
    }
}

