/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc;

import com.huawei.gaussdb.jdbc.GlobalConnectionTracker;
import com.huawei.gaussdb.jdbc.PGProperty;
import com.huawei.gaussdb.jdbc.QueryCNListUtils;
import com.huawei.gaussdb.jdbc.clusterchooser.GlobalClusterStatusTracker;
import com.huawei.gaussdb.jdbc.hostchooser.GlobalDomainResolveTracker;
import com.huawei.gaussdb.jdbc.hostchooser.MultiHostChooser;
import com.huawei.gaussdb.jdbc.jdbc.PgConnection;
import com.huawei.gaussdb.jdbc.jdbc.alt.cluster.ALTClusterContext;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectTask;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionMonitor;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionPropParser;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionResult;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionTimerTask;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.GnsConnStatus;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.DBConnectionTracker;
import com.huawei.gaussdb.jdbc.jdbc.alt.tac.TacLock;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.log.Tracer;
import com.huawei.gaussdb.jdbc.util.GT;
import com.huawei.gaussdb.jdbc.util.HostSpec;
import com.huawei.gaussdb.jdbc.util.PSQLException;
import com.huawei.gaussdb.jdbc.util.PSQLState;
import com.huawei.gaussdb.jdbc.util.SharedTimer;
import com.huawei.gaussdb.jdbc.util.StringUtils;
import com.huawei.gaussdb.jdbc.util.URLCoder;
import com.huawei.gaussdb.jdbc.util.WriterHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class Driver
implements java.sql.Driver {
    private static final char CONNECTION_URL_ARGS_SPLIT = '?';
    private static final String CONNECTION_URL_HOST_SPLIT = "//";
    private static final char CONNECTION_URL_DATABASE_SPLIT = '/';
    private static final String CONNECTION_URL_ADDRESSES_SPLIT = ",";
    private static final char CONNECTION_URL_PORT_SPLIT = ':';
    private static final char CONNECTION_HOST_IPV6_SUFFIX = ']';
    private static final String VALID_URL_PREFIX = "jdbc:gaussdb:";
    private static final int CONNECTION_URL_HOST_PREFIX_INDEX = 2;
    private static final String CONNECTION_PROPERTY_PGHOST = "PGHOST";
    private static final String CONNECTION_PROPERTY_PGHOSTURL = "PGHOSTURL";
    private static final String CONNECTION_PROPERTY_PGPORT = "PGPORT";
    private static final String CONNECTION_PROPERTY_PGPORTURL = "PGPORTURL";
    private static final String CONNECTION_PROPERTY_PGDBNAME = "PGDBNAME";
    private static final String CONNECTION_PROPERTY_DEFAULT_PGHOST = "localhost";
    private static final String CONNECTION_PROPERTY_DEFAULT_PGPORT = "5432";
    private static final String CONNECTION_PROPERTY_DEFAULT_PGDBNAME = "";
    private static Driver registeredDriver;
    private static final java.util.logging.Logger PARENT_LOGGER;
    private static Log LOGGER;
    private static SharedTimer sharedTimer;
    private static final String gsVersion = "GaussDB-Kernel_505.1.0 compiled at 2024-04-18-22:54:52 build 0605939";
    public static AtomicBoolean isLogFileCreated;
    private static final String[] SENSITIVE_CHARACTERS;
    private static Tracer tracer;
    private static AtomicBoolean tracerInitialized;
    private static final long CONNECT_GNS_TIMEOUT = 20000L;
    private Properties defaultProperties;
    private static String loggerHandlerFile;

    public static String getTracer() {
        if (tracer == null) {
            return null;
        }
        String traceId = tracer.getTraceId();
        if (traceId == null) {
            return null;
        }
        if (traceId.length() > 32) {
            traceId = traceId.substring(0, 32);
            LOGGER.warn("When used link trace, the length of trace id should be less or equals than 32, currently truncated to " + traceId + ".");
        } else if (traceId.length() < 1) {
            LOGGER.warn("When used link trace, the length of trace id should be greater than 0.");
        }
        return traceId;
    }

    private synchronized Properties getDefaultProperties() throws IOException {
        if (this.defaultProperties != null) {
            return this.defaultProperties;
        }
        try {
            this.defaultProperties = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    return Driver.this.loadDefaultProperties();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return this.defaultProperties;
    }

    private Properties loadDefaultProperties() throws IOException {
        Properties merged = new Properties();
        try {
            PGProperty.USER.set(merged, System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            LOGGER.debug("Can't find our classloader for the Driver; attempt to use the system class loader");
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            LOGGER.warn("Can't find a classloader for the Driver; not loading driver configuration from com/huawei/gaussdb/jdbc/driverconfig.properties");
            return merged;
        }
        LOGGER.debug("Loading driver configuration via classloader " + cl);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> urlEnum = cl.getResources("com/huawei/gaussdb/jdbc/driverconfig.properties");
        while (urlEnum.hasMoreElements()) {
            urls.add(urlEnum.nextElement());
        }
        for (int i = urls.size() - 1; i >= 0; --i) {
            URL url = (URL)urls.get(i);
            LOGGER.debug("Loading driver configuration from: " + url);
            InputStream is = url.openStream();
            merged.load(is);
            is.close();
        }
        return merged;
    }

    public static Properties GetProps(Properties defaults, Properties info) throws PSQLException {
        Properties newProps = new Properties(defaults);
        if (info != null) {
            Set<String> e = info.stringPropertyNames();
            for (String propName : e) {
                String propValue = info.getProperty(propName);
                if (propValue == null) {
                    throw new PSQLException(GT.tr("Properties for the driver contains a non-string value for the key ", new Object[0]) + propName, PSQLState.UNEXPECTED_ERROR);
                }
                newProps.setProperty(propName, propValue);
            }
        }
        return newProps;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Properties defaults;
        String[] legalUrlTags = new String[]{VALID_URL_PREFIX, "jdbc:dws:iam:"};
        boolean isUrlLegal = false;
        for (String urlTag : legalUrlTags) {
            if (!url.startsWith(urlTag)) continue;
            isUrlLegal = true;
        }
        if (!isUrlLegal) {
            return null;
        }
        try {
            defaults = this.getDefaultProperties();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Error loading default settings from driverconfig.properties", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        Properties props = Driver.GetProps(defaults, info);
        props = Driver.parseURL(url, props);
        if (props == null) {
            return null;
        }
        if (!this.parseConnectionProperties(props).booleanValue()) {
            return null;
        }
        try {
            LOGGER.debug("Connecting with URL: " + Driver.filterAuthenticationCredentials(url));
            this.connectToGns(props);
            long timeout = Driver.timeout(props);
            if (timeout <= 0L) {
                return Driver.makeConnection(url, props);
            }
            ConnectThread ct = new ConnectThread(url, props);
            Thread thread = new Thread((Runnable)ct, "GaussDB JDBC driver connection thread");
            thread.setDaemon(true);
            thread.start();
            return ct.getResult(timeout);
        }
        catch (PSQLException ex1) {
            LOGGER.debug("Connection error: ", ex1);
            throw ex1;
        }
        catch (AccessControlException ace) {
            throw new PSQLException(GT.tr("Your security policy has prevented the connection from being attempted.  You probably need to grant the connect java.net.SocketPermission to the database server host and port that you wish to connect to.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ace);
        }
        catch (Exception ex2) {
            LOGGER.debug("Unexpected connection error: ", ex2);
            throw new PSQLException(GT.tr("Something unusual has occured to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ex2);
        }
    }

    private void connectToGns(Properties props) {
        GnsConnectionResult gnsConnectionResult = Driver.makeGnsConnection(props);
        if (gnsConnectionResult.isConnectSuccess()) {
            PGProperty.ALT_CLUSTER_ID.set(props, gnsConnectionResult.getAltClusterId());
        }
    }

    private Boolean parseConnectionProperties(Properties props) throws PSQLException {
        Logger.setLoggerName(props.getProperty("logger"));
        if (Logger.isUsingJDKLogger()) {
            this.setupLoggerFromProperties(props);
        } else {
            LOGGER = Logger.getLogger("com.huawei.gaussdb.jdbc.Driver");
        }
        if (PGProperty.TRACE_INTERFACE_CLASS.get(props) != null && tracer == null) {
            String traceClass = PGProperty.TRACE_INTERFACE_CLASS.get(props);
            try {
                if (tracerInitialized.compareAndSet(false, true)) {
                    tracer = Class.forName(traceClass).asSubclass(Tracer.class).newInstance();
                }
            }
            catch (ClassCastException ce1) {
                tracerInitialized.set(false);
                LOGGER.warn("The currently specified class " + traceClass + ", not implement Tracer class.");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ce2) {
                tracerInitialized.set(false);
                LOGGER.warn("Failed to load tracer implementation class, error: ", ce2);
            }
        }
        Boolean parseStatus = true;
        if (PGProperty.PRIORITY_SERVERS.get(props) != null) {
            if (!GlobalClusterStatusTracker.isVaildPriorityServers(props)) {
                parseStatus = false;
            }
            GlobalClusterStatusTracker.refreshProperties(props);
        }
        if (PGProperty.PARSE_CANDIDATES_BY_DOMAIN.getBoolean(props) && !GlobalDomainResolveTracker.isValidPriorityAndPrimaryDomains(props)) {
            return false;
        }
        if (PGProperty.PARSE_CANDIDATES_BY_DOMAIN.getBoolean(props) && GlobalDomainResolveTracker.isVaildPrimaryDomains(props)) {
            GlobalClusterStatusTracker.refreshProperties(props);
        }
        this.checkAutoBalanceParamValid(props);
        if (MultiHostChooser.isUsingAutoLoadBalance(props) && !PGProperty.PARSE_CANDIDATES_BY_DOMAIN.getBoolean(props)) {
            if (!MultiHostChooser.isVaildPriorityLoadBalance(props)) {
                parseStatus = false;
            }
            QueryCNListUtils.refreshProperties(props);
        }
        return parseStatus;
    }

    private void checkAutoBalanceParamValid(Properties props) throws PSQLException {
        String autoBalance;
        boolean isAutoBalanceValid;
        block5: {
            block4: {
                String sessionType = props.getProperty("sessionType", "normal");
                List<String> validSessionTypes = Arrays.asList("singleNode", "globalReadOnly", "normal");
                boolean isSessionTypeValid = false;
                for (String validSessionType : validSessionTypes) {
                    if (!validSessionType.equalsIgnoreCase(sessionType)) continue;
                    isSessionTypeValid = true;
                    break;
                }
                if (!isSessionTypeValid) {
                    throw new PSQLException("sessionType error, sessionType value is " + sessionType + ", the right value is normal, singleNode, globalReadOnly", PSQLState.INVALID_PARAMETER_VALUE);
                }
                isAutoBalanceValid = false;
                autoBalance = props.getProperty("autoBalance", "false");
                if (!autoBalance.matches("priority\\d+")) break block4;
                int num = Integer.parseInt(autoBalance.substring("priority".length()));
                if (num < 0) break block5;
                isAutoBalanceValid = true;
                break block5;
            }
            List<String> validAutoBalanceValues = Arrays.asList("shuffle", "roundrobin", "leastconn", "specified", "true", "balance", "false");
            for (String validValue : validAutoBalanceValues) {
                if (!validValue.equals(autoBalance)) continue;
                isAutoBalanceValid = true;
                break;
            }
        }
        if (!isAutoBalanceValid) {
            throw new PSQLException("autoBalance error, autoBalance value is " + autoBalance + ", the right value is true, balance, roundrobin, priorityN, specified, shuffle, leastconn", PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    private Boolean initLoggerProperties(String driverLogLevel) {
        if (driverLogLevel == null) {
            return false;
        }
        if (!"OFF".equalsIgnoreCase(driverLogLevel) && !isLogFileCreated.compareAndSet(false, true)) {
            return false;
        }
        if ("OFF".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.OFF);
            return false;
        }
        if ("DEBUG".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.FINE);
        } else if ("TRACE".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.FINEST);
        } else if ("INFO".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.INFO);
        } else {
            PARENT_LOGGER.setLevel(Level.OFF);
        }
        return true;
    }

    private void setupLoggerFromProperties(Properties props) {
        String driverLogLevel = PGProperty.LOGGER_LEVEL.get(props);
        if (!this.initLoggerProperties(driverLogLevel).booleanValue()) {
            return;
        }
        String driverLogFile = PGProperty.LOGGER_FILE.getDefaultValue();
        if (driverLogFile != null && driverLogFile.equals(loggerHandlerFile)) {
            return;
        }
        for (Handler handlers : PARENT_LOGGER.getHandlers()) {
            handlers.close();
            PARENT_LOGGER.removeHandler(handlers);
            loggerHandlerFile = null;
        }
        Handler handler = null;
        if (driverLogFile != null) {
            try {
                handler = new FileHandler(driverLogFile);
                loggerHandlerFile = driverLogFile;
            }
            catch (Exception ex) {
                System.err.println("Cannot enable FileHandler, fallback to ConsoleHandler.");
            }
        }
        SimpleFormatter formatter = new SimpleFormatter();
        if (handler == null) {
            handler = DriverManager.getLogWriter() != null ? new WriterHandler(DriverManager.getLogWriter()) : (DriverManager.getLogStream() != null ? new StreamHandler(DriverManager.getLogStream(), formatter) : new StreamHandler(System.err, formatter));
        } else {
            handler.setFormatter(formatter);
        }
        handler.setLevel(PARENT_LOGGER.getLevel());
        PARENT_LOGGER.setUseParentHandlers(false);
        PARENT_LOGGER.addHandler(handler);
    }

    private static Connection makeConnection(String url, Properties props) throws SQLException {
        PgConnection pgConnection = new PgConnection(Driver.hostSpecs(props), Driver.user(props), Driver.database(props), props, url);
        if (PGProperty.REPLICATION.get(props) == null) {
            pgConnection.initCompatibilityMode();
        }
        GlobalConnectionTracker.possessConnectionReference(pgConnection.getQueryExecutor(), props);
        if (DBConnectionTracker.enableFCF(props)) {
            DBConnectionTracker instance = DBConnectionTracker.getInstance();
            instance.addConnectionItem(pgConnection, props);
        }
        return pgConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GnsConnectionResult makeGnsConnection(Properties props) {
        ALTClusterContext context = new ALTClusterContext();
        if (!PGProperty.ENABLE_ALT.getBoolean(props)) {
            return new GnsConnectionResult(false);
        }
        List<HostSpec> gnsHostSpecs = GnsConnectionPropParser.getGnsHostSpecs(props);
        if (gnsHostSpecs.isEmpty()) {
            LOGGER.warn("enableALT is true, but gns is invalid or no available gns");
            return new GnsConnectionResult(false);
        }
        String altClusterId = GnsConnectionPropParser.getAltClusterId(gnsHostSpecs);
        DBConnectionTracker dbConnectionTracker = context.getDBConnectionTracker();
        if (dbConnectionTracker.isGnsInit(altClusterId)) {
            return new GnsConnectionResult(true, altClusterId, null);
        }
        TacLock tacLock = context.getGnsLockManager().register(altClusterId);
        Lock connectLock = tacLock.getConnectLock();
        long expiryTime = System.currentTimeMillis() + 20000L;
        try {
            if (!connectLock.tryLock(20000L, TimeUnit.MILLISECONDS)) {
                GnsConnectionResult gnsConnectionResult = new GnsConnectionResult(false);
                return gnsConnectionResult;
            }
            if (dbConnectionTracker.isGnsInit(altClusterId)) {
                GnsConnectionResult gnsConnectionResult = new GnsConnectionResult(true, altClusterId, null);
                return gnsConnectionResult;
            }
            GnsConnectTask gnsConnectTask = new GnsConnectTask(props, context);
            gnsConnectTask.lock();
            context.getALTThreadPool().executeTask(gnsConnectTask);
            long currentTime = System.currentTimeMillis();
            if (currentTime >= expiryTime || !gnsConnectTask.waitOnLock(expiryTime - currentTime)) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("connect to gns timeout");
                }
                gnsConnectTask.setGnsConnStatus(GnsConnStatus.TIME_OUT);
                GnsConnectionResult gnsConnectionResult = new GnsConnectionResult(false);
                return gnsConnectionResult;
            }
            GnsConnectionMonitor gnsConnectionMonitor = context.getGnsConnectionMonitor();
            gnsConnectionMonitor.addGnsConnectTask(altClusterId, gnsConnectTask);
            gnsConnectionMonitor.register(props, new GnsConnectionTimerTask(props, context));
            GnsConnectionResult gnsConnectionResult = new GnsConnectionResult(gnsConnectTask, gnsConnectTask.getConn(), altClusterId);
            return gnsConnectionResult;
        }
        catch (InterruptedException e) {
            GnsConnectionResult gnsConnectionResult = new GnsConnectionResult(false);
            return gnsConnectionResult;
        }
        finally {
            connectLock.unlock();
        }
    }

    @Override
    public boolean acceptsURL(String url) throws PSQLException {
        return Driver.parseURL(url, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws PSQLException {
        Properties copy = new Properties(info);
        copy = Driver.parseURL(url, copy);
        PGProperty[] knownProperties = PGProperty.values();
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < props.length; ++i) {
            props[i] = knownProperties[i].toDriverPropertyInfo(copy);
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return 42;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Deprecated
    public static String getVersion() {
        return "GaussDB JDBC Driver /*$mvn.project.property.parsedversion.osgiversion$*/";
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    private static void checkPortValid(String port) throws PSQLException {
        if (port == null || port.isEmpty()) {
            return;
        }
        try {
            int portNum = Integer.parseInt(port);
            if (portNum < 1 || portNum > 65535) {
                LOGGER.warn("JDBC URL port: " + port + " not valid (1:65535) ");
                throw new PSQLException(GT.tr("Jdbc url port is not valid(1~65535)", new Object[0]), PSQLState.INVALID_CONNECTION_URL);
            }
        }
        catch (NumberFormatException exception) {
            LOGGER.warn("JDBC URL invalid port number: " + port);
            throw new PSQLException(GT.tr("Jdbc url port must be integer(1~65535)", new Object[0]), PSQLState.INVALID_CONNECTION_URL, (Throwable)exception);
        }
    }

    public static Properties parseURL(String url, Properties defaults) throws PSQLException {
        String[] legalUrlTags;
        boolean isUrlLegal = false;
        for (String urlTag : legalUrlTags = new String[]{VALID_URL_PREFIX, "jdbc:dws:iam:"}) {
            if (!url.startsWith(urlTag)) continue;
            isUrlLegal = true;
        }
        if (!isUrlLegal) {
            LOGGER.debug("JDBC URL must start with \"jdbc:gaussdb:\" or \"jdbc:dws:iam:\" but was: " + Driver.filterAuthenticationCredentials(url));
            return null;
        }
        UrlInfo urlInfo = Driver.splitUrl(url);
        Properties urlProps = new Properties(defaults);
        String hosts = Driver.getUrlHostWithDefaultProperties(urlInfo.getHosts(), urlProps.getProperty(CONNECTION_PROPERTY_PGHOST));
        urlProps.setProperty(CONNECTION_PROPERTY_PGHOST, hosts);
        urlProps.setProperty(CONNECTION_PROPERTY_PGHOSTURL, hosts);
        String ports = Driver.getUrlPortWithDefaultProperties(urlInfo.getPorts(), urlProps.getProperty(CONNECTION_PROPERTY_PGPORT));
        urlProps.setProperty(CONNECTION_PROPERTY_PGPORT, ports);
        urlProps.setProperty(CONNECTION_PROPERTY_PGPORTURL, ports);
        String dbName = Driver.getUrlDbNameWithDefaultProperties(urlInfo.getDatabase(), urlProps.getProperty(CONNECTION_PROPERTY_PGDBNAME));
        urlProps.setProperty(CONNECTION_PROPERTY_PGDBNAME, URLCoder.decode(dbName));
        if (urlInfo.getArgs() != null) {
            urlProps.putAll((Map<?, ?>)Driver.parseParam(urlInfo.getArgs()));
        }
        GnsConnectionPropParser.parseGnsServer(urlProps);
        return urlProps;
    }

    private static String filterAuthenticationCredentials(String url) {
        String notSensitiveUrl = url;
        int paramStartIndex = notSensitiveUrl.indexOf("?");
        if (paramStartIndex != -1) {
            LinkedHashMap<String, String> paramsMap = Driver.parseParam(notSensitiveUrl.substring(paramStartIndex + 1));
            StringBuilder stringBuilder = new StringBuilder(notSensitiveUrl.substring(0, paramStartIndex) + "?");
            for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
                boolean isKeyword = false;
                for (String sensitiveCharacter : SENSITIVE_CHARACTERS) {
                    if (!entry.getKey().equals(sensitiveCharacter)) continue;
                    isKeyword = true;
                    break;
                }
                if (isKeyword) continue;
                stringBuilder.append(entry.getKey() + "=" + entry.getValue() + "&");
            }
            notSensitiveUrl = stringBuilder.toString();
            if (notSensitiveUrl.endsWith("?") || notSensitiveUrl.endsWith("&")) {
                notSensitiveUrl = notSensitiveUrl.substring(0, notSensitiveUrl.length() - 1);
            }
        }
        return notSensitiveUrl;
    }

    private static LinkedHashMap<String, String> parseParam(String urlArgs) {
        String[] args;
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        for (String token : args = urlArgs.split("&")) {
            if (token.isEmpty()) continue;
            int l_pos = token.indexOf(61);
            if (l_pos == -1) {
                paramsMap.put(token, CONNECTION_PROPERTY_DEFAULT_PGDBNAME);
                continue;
            }
            paramsMap.put(token.substring(0, l_pos), URLCoder.decode(token.substring(l_pos + 1)));
        }
        return paramsMap;
    }

    public static HostSpec[] GetHostSpecs(Properties props) {
        return Driver.hostSpecs(props);
    }

    public static HostSpec[] getURLHostSpecs(Properties props) {
        return Driver.urlHostSpecs(props);
    }

    public static String GetUser(Properties props) {
        return Driver.user(props);
    }

    public static String GetDatabase(Properties props) {
        return Driver.database(props);
    }

    private static HostSpec[] urlHostSpecs(Properties props) {
        String[] ports = props.getProperty(CONNECTION_PROPERTY_PGPORTURL).split(CONNECTION_URL_ADDRESSES_SPLIT);
        String[] hosts = props.getProperty(CONNECTION_PROPERTY_PGHOSTURL).split(CONNECTION_URL_ADDRESSES_SPLIT, ports.length);
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]));
        }
        return hostSpecs;
    }

    private static HostSpec[] hostSpecs(Properties props) {
        String[] ports = props.getProperty(CONNECTION_PROPERTY_PGPORT).split(CONNECTION_URL_ADDRESSES_SPLIT);
        String[] hosts = props.getProperty(CONNECTION_PROPERTY_PGHOST).split(CONNECTION_URL_ADDRESSES_SPLIT, ports.length);
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]));
        }
        return hostSpecs;
    }

    private static String user(Properties props) {
        return props.getProperty("user", CONNECTION_PROPERTY_DEFAULT_PGDBNAME);
    }

    private static String database(Properties props) {
        return props.getProperty(CONNECTION_PROPERTY_PGDBNAME, CONNECTION_PROPERTY_DEFAULT_PGDBNAME);
    }

    private static long timeout(Properties props) {
        String timeout = PGProperty.LOGIN_TIMEOUT.get(props);
        if (timeout != null) {
            try {
                return (long)(Float.parseFloat(timeout) * 1000.0f);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Couldn't parse loginTimeout value: " + timeout);
            }
        }
        return (long)DriverManager.getLoginTimeout() * 1000L;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class<?> callClass, String functionName) {
        return new SQLFeatureNotSupportedException(GT.tr("METHOD_IS_NOT_IMPLEMENTED", callClass.getName() + "." + functionName), PSQLState.NOT_IMPLEMENTED.getState());
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        if (Logger.isUsingJDKLogger()) {
            return PARENT_LOGGER;
        }
        return null;
    }

    public static SharedTimer getSharedTimer() {
        return sharedTimer;
    }

    public static void register() throws SQLException {
        if (Driver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        registeredDriver = new Driver();
        DriverManager.registerDriver(registeredDriver);
        isLogFileCreated = new AtomicBoolean(false);
    }

    public static void deregister() throws SQLException {
        if (!Driver.isRegistered()) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    public static String getGSVersion() {
        return gsVersion;
    }

    private static void checkUrlArgs(String urlArgs) {
        if (urlArgs.toLowerCase(Locale.US).contains("his_kms_info")) {
            LOGGER.warn("It is not recommended to config HIS_KMS_INFO in JDBC URL, because the hisSecret information may be contained");
        }
        if (urlArgs.toLowerCase(Locale.US).contains("key_info")) {
            LOGGER.warn("It is not recommended to config 'key_info' which may contain sensitive parameter in JDBC URL");
        }
        if (urlArgs.toLowerCase(Locale.US).contains("password")) {
            LOGGER.warn("It is not recommended to use password in JDBC URL");
        }
    }

    private static UrlInfo splitUrl(String url) throws PSQLException {
        String urlServer;
        UrlInfo urlInfo = new UrlInfo();
        if (url.contains(String.valueOf('?'))) {
            int urlArgsSplitIndex = url.indexOf(63);
            urlServer = url.substring(0, urlArgsSplitIndex);
            String urlArgs = url.substring(urlArgsSplitIndex + 1);
            Driver.checkUrlArgs(urlArgs);
            urlInfo.setArgs(urlArgs);
        } else {
            urlServer = url;
        }
        String urlServerWithoutPrefix = urlServer.substring(VALID_URL_PREFIX.length());
        if (!urlServerWithoutPrefix.startsWith(CONNECTION_URL_HOST_SPLIT)) {
            urlInfo.setDatabase(urlServerWithoutPrefix);
            return urlInfo;
        }
        String addressAndDatabase = urlServerWithoutPrefix.substring(2);
        if (!addressAndDatabase.contains(String.valueOf('/'))) {
            LOGGER.warn("JDBC URL must contain a / at the end of the host or port: " + Driver.filterAuthenticationCredentials(url));
            throw new PSQLException(GT.tr("Connection url must contains database when it contains the server address.", new Object[0]), PSQLState.INVALID_CONNECTION_URL);
        }
        int urlDatabaseSplitIndex = addressAndDatabase.indexOf(47);
        String serverAddress = addressAndDatabase.substring(0, urlDatabaseSplitIndex);
        String database = addressAndDatabase.substring(urlDatabaseSplitIndex + 1);
        urlInfo.setDatabase(database);
        List<AddressInfo> addressInfoList = Driver.parseMultiAddresses(serverAddress);
        ArrayList<String> hostList = new ArrayList<String>();
        ArrayList<String> portList = new ArrayList<String>();
        for (AddressInfo addressInfo : addressInfoList) {
            hostList.add(addressInfo.getHost());
            portList.add(addressInfo.getPort());
        }
        urlInfo.setHosts(hostList);
        urlInfo.setPorts(portList);
        return urlInfo;
    }

    private static List<AddressInfo> parseMultiAddresses(String serverAddresses) throws PSQLException {
        String[] addresses = serverAddresses.split(CONNECTION_URL_ADDRESSES_SPLIT);
        ArrayList<AddressInfo> addressInfoList = new ArrayList<AddressInfo>();
        for (String address : addresses) {
            AddressInfo addressInfo = Driver.parseAddress(address);
            Driver.checkPortValid(addressInfo.getPort());
            addressInfoList.add(addressInfo);
        }
        return addressInfoList;
    }

    private static AddressInfo parseAddress(String address) {
        int splitCount = StringUtils.countChar(address, ':');
        if (splitCount == 0 || splitCount == 1) {
            return Driver.parseIPv4Address(address);
        }
        return Driver.parseIPv6Address(address);
    }

    private static AddressInfo parseIPv6Address(String address) {
        int colonIndex;
        int bracketIndex = address.indexOf(93);
        if (bracketIndex < (colonIndex = address.lastIndexOf(58))) {
            return new AddressInfo(address.substring(0, colonIndex), address.substring(colonIndex + 1));
        }
        return new AddressInfo(address, CONNECTION_PROPERTY_DEFAULT_PGDBNAME);
    }

    private static AddressInfo parseIPv4Address(String address) {
        if (!address.contains(String.valueOf(':'))) {
            return new AddressInfo(address, CONNECTION_PROPERTY_DEFAULT_PGDBNAME);
        }
        int splitIndex = address.indexOf(58);
        return new AddressInfo(address.substring(0, splitIndex), address.substring(splitIndex + 1));
    }

    private static String getUrlPortWithDefaultProperties(List<String> ports, String defaultProperty) {
        String defaultPort;
        String string = defaultPort = defaultProperty == null ? CONNECTION_PROPERTY_DEFAULT_PGPORT : defaultProperty;
        if (ports == null) {
            return defaultPort;
        }
        for (int i = 0; i < ports.size(); ++i) {
            if (!ports.get(i).isEmpty()) continue;
            ports.set(i, defaultPort);
        }
        return StringUtils.join(CONNECTION_URL_ADDRESSES_SPLIT, ports);
    }

    private static String getUrlDbNameWithDefaultProperties(String database, String defaultProperty) {
        if (database.isEmpty()) {
            return defaultProperty == null ? CONNECTION_PROPERTY_DEFAULT_PGDBNAME : defaultProperty;
        }
        return database;
    }

    private static String getUrlHostWithDefaultProperties(List<String> hosts, String defaultProperty) {
        if (hosts == null) {
            return defaultProperty == null ? CONNECTION_PROPERTY_DEFAULT_PGHOST : defaultProperty;
        }
        return StringUtils.join(CONNECTION_URL_ADDRESSES_SPLIT, hosts);
    }

    static {
        PARENT_LOGGER = java.util.logging.Logger.getLogger("com.huawei.gaussdb.jdbc");
        LOGGER = Logger.getLogger("com.huawei.gaussdb.jdbc.Driver");
        sharedTimer = new SharedTimer();
        SENSITIVE_CHARACTERS = new String[]{"sslpassword", "iamPassword", "password", "HIS_KMS_INFO", "key_info"};
        tracerInitialized = new AtomicBoolean(false);
        try {
            Driver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class AddressInfo {
        private String host;
        private String port;

        public AddressInfo(String host, String port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }
    }

    private static class UrlInfo {
        private List<String> hosts;
        private List<String> ports;
        private String database;
        private String args;

        private UrlInfo() {
        }

        public List<String> getHosts() {
            return this.hosts;
        }

        public void setHosts(List<String> hosts) {
            this.hosts = hosts;
        }

        public List<String> getPorts() {
            return this.ports;
        }

        public void setPorts(List<String> ports) {
            this.ports = ports;
        }

        public String getDatabase() {
            return this.database;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public String getArgs() {
            return this.args;
        }

        public void setArgs(String args) {
            this.args = args;
        }
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private Connection result;
        private Throwable resultException;
        private boolean abandoned;

        ConnectThread(String url, Properties props) {
            this.url = url;
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable error;
            Connection conn;
            try {
                conn = Driver.makeConnection(this.url, this.props);
                error = null;
            }
            catch (Throwable t) {
                conn = null;
                error = t;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.result = conn;
                    this.resultException = error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long timeout) throws SQLException {
            long expiry = System.currentTimeMillis() + timeout;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new PSQLException(GT.tr("Something unusual has occured to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long delay = expiry - System.currentTimeMillis();
                    if (delay <= 0L) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("CONNECTION_TIMED_OUT", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.abandoned = true;
                        throw new RuntimeException(GT.tr("Interrupted while attempting to connect.", new Object[0]));
                    }
                }
                return this.result;
            }
        }
    }
}

