/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc;

import com.huawei.gaussdb.jdbc.Driver;
import com.huawei.gaussdb.jdbc.PGRefCursorResultSet;
import com.huawei.gaussdb.jdbc.PGResultSetMetaData;
import com.huawei.gaussdb.jdbc.core.BaseConnection;
import com.huawei.gaussdb.jdbc.core.BaseStatement;
import com.huawei.gaussdb.jdbc.core.Encoding;
import com.huawei.gaussdb.jdbc.core.Field;
import com.huawei.gaussdb.jdbc.core.Oid;
import com.huawei.gaussdb.jdbc.core.Query;
import com.huawei.gaussdb.jdbc.core.ResultCursor;
import com.huawei.gaussdb.jdbc.core.ResultHandlerBase;
import com.huawei.gaussdb.jdbc.core.TypeInfo;
import com.huawei.gaussdb.jdbc.core.Utils;
import com.huawei.gaussdb.jdbc.core.types.PGBlob;
import com.huawei.gaussdb.jdbc.core.types.PGClob;
import com.huawei.gaussdb.jdbc.jdbc.BooleanTypeUtil;
import com.huawei.gaussdb.jdbc.jdbc.PgArray;
import com.huawei.gaussdb.jdbc.jdbc.PgBlob;
import com.huawei.gaussdb.jdbc.jdbc.PgClob;
import com.huawei.gaussdb.jdbc.jdbc.PgResultSetMetaData;
import com.huawei.gaussdb.jdbc.jdbc.PgSQLXML;
import com.huawei.gaussdb.jdbc.jdbc.PgStatement;
import com.huawei.gaussdb.jdbc.jdbc.TimestampUtils;
import com.huawei.gaussdb.jdbc.jdbc.TypeNode;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.ClientLogic;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.ClientLogicException;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.DistinctComparator;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.GroupByAggregator;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.GroupByAvgAggregator;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.GroupByComparator;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.GroupByCountAggregator;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.GroupByMaxAggregator;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.GroupByMinAggregator;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.GroupBySumAggregator;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.LimitOffsetMetaData;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.OrderByComparator;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.SortColumnMetaData;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.TargetColumnMetaData;
import com.huawei.gaussdb.jdbc.util.ByteConverter;
import com.huawei.gaussdb.jdbc.util.GT;
import com.huawei.gaussdb.jdbc.util.HStoreConverter;
import com.huawei.gaussdb.jdbc.util.PGbytea;
import com.huawei.gaussdb.jdbc.util.PGobject;
import com.huawei.gaussdb.jdbc.util.PGtokenizer;
import com.huawei.gaussdb.jdbc.util.PSQLException;
import com.huawei.gaussdb.jdbc.util.PSQLState;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class PgResultSet
implements ResultSet,
PGRefCursorResultSet {
    private static final int RECORDID_OID = 2249;
    private static final int MIN_TABLE_OID = 16000;
    private boolean updateable = false;
    private boolean doingUpdates = false;
    private HashMap<String, Object> updateValues = null;
    private boolean usingOID = false;
    private List<PrimaryKey> primaryKeys;
    private boolean singleTable = false;
    private String onlyTable = "";
    private String tableName = null;
    private PreparedStatement updateStatement = null;
    private PreparedStatement insertStatement = null;
    private PreparedStatement deleteStatement = null;
    private PreparedStatement selectStatement = null;
    private ResultSetMetaData rsMetaData;
    private final int resultsettype;
    private final int resultsetconcurrency;
    private int fetchdirection = 1002;
    private TimeZone defaultTimeZone;
    private boolean isClientLogicRecordDataLoaded = false;
    private boolean isAnyColumnContainsClientLogic = false;
    private boolean didClientLogicFail = false;
    private String[] lastGroupValueList;
    private ArrayList<GroupByAggregator> aggregationFunctionList;
    private String[] lastDistinctValueList;
    private boolean enableStreamingQuery = false;
    protected final BaseConnection connection;
    protected final BaseStatement statement;
    protected Field[] fields;
    protected final Query originalQuery;
    protected final int maxRows;
    protected final int maxFieldSize;
    protected List<byte[][]> rows;
    protected int current_row = -1;
    protected int row_offset;
    protected byte[][] this_row;
    protected SQLWarning warnings = null;
    protected boolean wasNullFlag = false;
    protected boolean onInsertRow = false;
    private byte[][] rowBuffer = null;
    protected int fetchSize;
    protected ResultCursor cursor;
    private Map<String, Integer> columnNameIndexMap;
    protected boolean isUpperCase = false;
    protected boolean isClosed = false;
    private String sqlExecuteState;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private String refCursorName;
    private static final BigInteger BYTEMAX = new BigInteger(Byte.toString((byte)127));
    private static final BigInteger BYTEMIN = new BigInteger(Byte.toString((byte)-128));
    private static final NumberFormatException FAST_NUMBER_FAILED = new NumberFormatException(){

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };
    private static final BigInteger SHORTMAX = new BigInteger(Short.toString((short)Short.MAX_VALUE));
    private static final BigInteger SHORTMIN = new BigInteger(Short.toString((short)Short.MIN_VALUE));
    private static final BigInteger INTMAX = new BigInteger(Integer.toString(Integer.MAX_VALUE));
    private static final BigInteger INTMIN = new BigInteger(Integer.toString(Integer.MIN_VALUE));
    private static final BigInteger LONGMAX = new BigInteger(Long.toString(Long.MAX_VALUE));
    private static final BigInteger LONGMIN = new BigInteger(Long.toString(Long.MIN_VALUE));

    public void setSqlExecuteState(String sqlExecuteState) {
        this.sqlExecuteState = sqlExecuteState;
    }

    public boolean isEnableStreamingQuery() {
        return this.enableStreamingQuery;
    }

    public void setEnableStreamingQuery(boolean enableStreamingQuery) {
        this.enableStreamingQuery = enableStreamingQuery;
    }

    protected void setUppercase(boolean isUpperCase) {
        this.isUpperCase = isUpperCase;
    }

    protected void setClosed(boolean closed) {
        this.isClosed = closed;
    }

    private String resultUppercase(String result) {
        return this.isUpperCase && result != null && !result.isEmpty() ? result.toUpperCase(Locale.ENGLISH) : result;
    }

    protected ResultSetMetaData createMetaData() throws SQLException {
        return new PgResultSetMetaData(this.connection, this.fields);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.rsMetaData == null) {
            this.rsMetaData = this.createMetaData();
        }
        return this.rsMetaData;
    }

    PgResultSet(Query originalQuery, BaseStatement statement, Field[] fields, List<byte[][]> tuples, ResultCursor cursor, int maxRows, int maxFieldSize, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        if (tuples == null) {
            throw new NullPointerException("tuples must be non-null");
        }
        if (fields == null) {
            throw new NullPointerException("fields must be non-null");
        }
        this.originalQuery = originalQuery;
        this.connection = (BaseConnection)statement.getConnection();
        this.statement = statement;
        this.fields = fields;
        this.rows = tuples;
        this.clientLogicGetData(false);
        this.cursor = cursor;
        this.maxRows = maxRows;
        this.maxFieldSize = maxFieldSize;
        this.resultsettype = rsType;
        this.resultsetconcurrency = rsConcurrency;
    }

    public static String bytesArrayToHexString(byte[] bytes) {
        char[] hexCharArray = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int val = bytes[i] & 0xFF;
            hexCharArray[i * 2] = HEX_ARRAY[val >>> 4];
            hexCharArray[i * 2 + 1] = HEX_ARRAY[val & 0xF];
        }
        return new String(hexCharArray);
    }

    private void clientLogicGetDataFromRecord(ClientLogic clientLogic, Field field, Encoding encoding, int fieldIndex) throws SQLException {
        if (!ClientLogic.isClientLogicField(field.getOID()) && field.getClientLogicFieldOriginalIdS() != null && field.getClientLogicFieldOriginalIdS().size() > 0) {
            try {
                for (int rowIndex = 0; rowIndex < this.rows.size(); ++rowIndex) {
                    byte[] fieldData = this.rows.get(rowIndex)[fieldIndex];
                    if (fieldData == null) continue;
                    String clientLogicValue = encoding.decode(fieldData);
                    String userInputValue = "";
                    try {
                        userInputValue = clientLogic.runClientLogic4Record(clientLogicValue, field.getClientLogicFieldOriginalIdS());
                    }
                    catch (ClientLogicException e) {
                        this.connection.getLogger().error("client logic failed for field:" + field.getColumnLabel() + ", value: " + clientLogicValue + " Error:" + e.getErrorCode() + ":" + e.getErrorText());
                        throw e;
                    }
                    this.rows.get((int)rowIndex)[fieldIndex] = encoding.encode(userInputValue);
                }
            }
            catch (IOException e) {
                this.connection.getLogger().error("client logic failed encoding on IOException for field:" + field.getColumnLabel());
                throw new SQLException(e.getMessage());
            }
        }
    }

    boolean getDidClientLogicFail() {
        return this.didClientLogicFail;
    }

    public Field[] getFields() {
        return this.fields;
    }

    /*
     * Unable to fully structure code
     */
    void clientLogicGetData(boolean isOnRetry) throws SQLException {
        clientLogic = this.connection.getClientLogic();
        if (clientLogic == null) {
            return;
        }
        if (this.isClientLogicRecordDataLoaded && !this.isAnyColumnContainsClientLogic) {
            return;
        }
        encoding = null;
        try {
            encoding = this.connection.getEncoding();
        }
        catch (SQLException e1) {
            this.connection.getLogger().error("client logic failed - could not get connection encoding");
            return;
        }
        fieldIndex = 0;
        for (Field field : this.fields) {
            if (ClientLogic.isClientLogicField(field.getOID())) {
                this.isAnyColumnContainsClientLogic = true;
                for (rowIndex = 0; rowIndex < this.rows.size(); ++rowIndex) {
                    try {
                        if (this.rows.get(rowIndex)[fieldIndex] == null) continue;
                        hasError = false;
                        userInputValue = "";
                        try {
                            userInputValue = clientLogic.runClientLogic(this.rows.get(rowIndex)[fieldIndex], field.getMod());
                        }
                        catch (ClientLogicException e) {
                            hasError = true;
                            this.didClientLogicFail = true;
                            this.connection.getLogger().error("client logic failed for field:" + field.getColumnLabel() + ", Error:" + e.getErrorCode() + ":" + e.getErrorText());
                        }
                        v0 = isKeepValue = hasError == false || isOnRetry != false;
                        if (!isKeepValue) continue;
                        this.rows.get((int)rowIndex)[fieldIndex] = encoding.encode(userInputValue);
                        continue;
                    }
                    catch (IOException e) {
                        this.connection.getLogger().error("client logic failed encoding on IOException for field:" + field.getColumnLabel());
                    }
                }
            } else {
                try {
                    if (field.getOID() != 2249 && field.getOID() <= 16000 || (oids = clientLogic.getRecordIDs(field.getColumnLabel(), field.getOID())) == null || oids.size() <= 0) ** GOTO lbl45
                    this.isAnyColumnContainsClientLogic = true;
                    field.setClientLogicFieldOriginalIdS(oids);
                }
                catch (ClientLogicException e) {
                    this.connection.getLogger().error("client logic failed loading fields data Error:" + e.getErrorCode() + ":" + e.getErrorText());
                    throw e;
                }
            }
lbl45:
            // 3 sources

            this.isClientLogicRecordDataLoaded = true;
            this.clientLogicGetDataFromRecord(clientLogic, field, encoding, fieldIndex);
            ++fieldIndex;
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        if (this.connection.getLogger().isTraceEnabled()) {
            this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getURL columnIndex: " + columnIndex);
        }
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "getURL(int)");
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    protected Object internalGetObject(int columnIndex, Field field) throws SQLException {
        switch (this.getSQLType(columnIndex)) {
            case -7: 
            case 16: {
                return this.getBoolean(columnIndex);
            }
            case 2009: {
                return this.getSQLXML(columnIndex);
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getInt(columnIndex);
            }
            case -5: {
                return this.getBigInt(columnIndex);
            }
            case 2: 
            case 3: {
                int scale = this.getScale(columnIndex);
                return this.getBigDecimal(columnIndex, scale);
            }
            case 7: {
                return Float.valueOf(this.getFloat(columnIndex));
            }
            case 6: 
            case 8: {
                return this.getDouble(columnIndex);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getDefaultTimestamp(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 2003: {
                return this.getArray(columnIndex);
            }
            case 2005: {
                return this.getClob(columnIndex);
            }
            case 2004: {
                return this.getBlob(columnIndex);
            }
        }
        String type = this.getPGType(columnIndex);
        if (type.equals("unknown")) {
            return this.getString(columnIndex);
        }
        if (type.equals("uuid")) {
            if (this.isBinary(columnIndex)) {
                return this.getUUID(this.this_row[columnIndex - 1]);
            }
            return this.getUUID(this.getString(columnIndex));
        }
        if (type.equals("refcursor")) {
            String cursorName = this.getString(columnIndex);
            StringBuilder sb = new StringBuilder("FETCH ALL IN ");
            Utils.escapeIdentifier(sb, cursorName, this.connection.getCompatibilityMode());
            ResultSet rs = this.connection.execSQLQuery(sb.toString(), this.resultsettype, 1007);
            sb.setLength(0);
            sb.append("CLOSE ");
            Utils.escapeIdentifier(sb, cursorName, this.connection.getCompatibilityMode());
            this.connection.execSQLUpdate(sb.toString());
            ((PgResultSet)rs).setRefCursor(cursorName);
            return rs;
        }
        if ("hstore".equals(type)) {
            if (this.isBinary(columnIndex)) {
                return HStoreConverter.fromBytes(this.this_row[columnIndex - 1], this.connection.getEncoding());
            }
            return HStoreConverter.fromString(this.getString(columnIndex));
        }
        return null;
    }

    protected Number getBigInt(int columnIndex) throws SQLException {
        return this.getLong(columnIndex);
    }

    protected int getScale(int columnIndex) {
        Field field = this.fields[columnIndex - 1];
        if (field.getMod() == -1) {
            return -1;
        }
        return field.getMod() - 4 & 0xFFFF;
    }

    protected Object getDefaultTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    private void checkScrollable() throws SQLException {
        this.checkClosed();
        if (this.resultsettype == 1003) {
            throw new PSQLException(GT.tr("OPERATION_REQUIRES_A_SCROLLABLE_RESULT_SET", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean absolute(int index) throws SQLException {
        int internalIndex;
        this.checkScrollable();
        if (index == 0) {
            this.beforeFirst();
            return false;
        }
        int rows_size = this.rows.size();
        if (index < 0) {
            if (index < -rows_size) {
                this.beforeFirst();
                return false;
            }
            internalIndex = rows_size + index;
        } else {
            if (index > rows_size) {
                this.afterLast();
                return false;
            }
            internalIndex = index - 1;
        }
        this.current_row = internalIndex;
        this.initRowBuffer();
        this.onInsertRow = false;
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkScrollable();
        int rows_size = this.rows.size();
        if (rows_size > 0) {
            this.current_row = rows_size;
        }
        this.onInsertRow = false;
        this.this_row = null;
        this.rowBuffer = null;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkScrollable();
        if (!this.rows.isEmpty()) {
            this.current_row = -1;
        }
        this.onInsertRow = false;
        this.this_row = null;
        this.rowBuffer = null;
    }

    @Override
    public boolean first() throws SQLException {
        this.checkScrollable();
        if (this.rows.size() <= 0) {
            return false;
        }
        this.current_row = 0;
        this.initRowBuffer();
        this.onInsertRow = false;
        return true;
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    protected Array makeArray(int oid, byte[] value) throws SQLException {
        return new PgArray(this.connection, oid, value);
    }

    protected Array makeArray(int oid, String value) throws SQLException {
        return new PgArray(this.connection, oid, value);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        return this.getArray(this.this_row[columnIndex - 1], this.fields[columnIndex - 1]);
    }

    private Array getArray(byte[] data, Field field) throws SQLException {
        int oid = field.getOID();
        if (this.isBinary(field)) {
            return this.makeArray(oid, data);
        }
        if (this.fields != null && this.fields.length >= 2 && this.fields[1].getTypeNode() != null) {
            return new PgArray(this.connection, oid, this.getString(data, field), this.fields[1].getTypeNode());
        }
        TypeNode typeNode = TypeNode.getNestedInfo(oid, this.connection);
        if (typeNode == null || typeNode.getName().equals("")) {
            return this.makeArray(oid, this.getFixedString(data, field));
        }
        return new PgArray(this.connection, oid, this.getString(data, field), typeNode);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(columnIndex, -1);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    protected Blob makeBlob(long oid) throws SQLException {
        return new PgBlob(this.connection, oid);
    }

    public byte[] toBytes(String str) {
        if (str == null || str.trim().equals("")) {
            return new byte[0];
        }
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < str.length() / 2; ++i) {
            String subStr = str.substring(i * 2, i * 2 + 2);
            bytes[i] = (byte)Integer.parseInt(subStr, 16);
        }
        return bytes;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        return this.getBlob(this.this_row[columnIndex - 1], this.fields[columnIndex - 1]);
    }

    private Blob getBlob(byte[] data, Field field) throws SQLException {
        if (this.isBinary(field)) {
            PGBlob blob = new PGBlob();
            blob.setBytes(1L, data);
            return blob;
        }
        String s = this.getString(data, field);
        byte[] byt = this.toBytes(s);
        PGBlob blob = new PGBlob();
        blob.setBytes(1L, byt);
        return blob;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int i) throws SQLException {
        this.checkResultSet(i);
        if (this.wasNullFlag) {
            return null;
        }
        return new CharArrayReader(this.getString(i).toCharArray());
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    protected Clob makeClob(long oid) throws SQLException {
        return new PgClob(this.connection, oid);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        return this.getClob(this.this_row[columnIndex - 1], this.fields[columnIndex - 1]);
    }

    private Clob getClob(byte[] data, Field field) throws SQLException {
        String str = this.getString(data, field);
        PGClob clob = new PGClob();
        clob.setString(1L, str);
        return clob;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultsetconcurrency;
    }

    @Override
    public java.sql.Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        return this.getDate(this.this_row[columnIndex - 1], this.fields[columnIndex - 1], cal);
    }

    private java.sql.Date getDate(byte[] data, Field field, Calendar cal) throws SQLException {
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        if (this.isBinary(field)) {
            int oid = field.getOID();
            TimeZone tz = cal.getTimeZone();
            if (oid == 1082) {
                return this.connection.getTimestampUtils().toDateBin(tz, data);
            }
            if (oid == 1114 || oid == 1184) {
                Timestamp timestamp = this.getTimestamp(data, field, cal);
                return this.connection.getTimestampUtils().convertToDate(timestamp.getTime(), tz);
            }
            throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(oid), "date"), PSQLState.DATA_TYPE_MISMATCH);
        }
        String dateStr = this.getString(data, field);
        return this.connection.getTimestampUtils().toDate(cal, dateStr);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        return this.getTime(this.this_row[columnIndex - 1], this.fields[columnIndex - 1], cal);
    }

    private Time getTime(byte[] data, Field field, Calendar cal) throws SQLException {
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        if (this.isBinary(field)) {
            int oid = field.getOID();
            TimeZone tz = cal.getTimeZone();
            if (oid == 1083 || oid == 1266) {
                return this.connection.getTimestampUtils().toTimeBin(tz, data);
            }
            if (oid == 1114 || oid == 1184) {
                Timestamp timestamp = this.getTimestamp(data, field, cal);
                long timeMillis = timestamp.getTime();
                if (oid == 1184) {
                    return new Time(timeMillis % TimeUnit.DAYS.toMillis(1L));
                }
                return this.connection.getTimestampUtils().convertToTime(timeMillis, tz);
            }
            throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(oid), "time"), PSQLState.DATA_TYPE_MISMATCH);
        }
        String string = this.getString(data, field);
        return this.connection.getTimestampUtils().toTime(cal, string);
    }

    private LocalTime getLocalTime(int i) throws SQLException {
        byte[] value = this.getRawValue(i);
        if (value == null) {
            return null;
        }
        if (this.isBinary(i)) {
            int col = i - 1;
            int oid = this.fields[col].getOID();
            if (oid == 1083) {
                return this.connection.getTimestampUtils().toLocalTimeBin(value);
            }
            throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(oid), "time"), PSQLState.DATA_TYPE_MISMATCH);
        }
        String string = this.getString(i);
        return this.connection.getTimestampUtils().toLocalTime(string);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        return this.getTimestamp(this.this_row[columnIndex - 1], this.fields[columnIndex - 1], cal);
    }

    private Timestamp getTimestamp(byte[] data, Field field, Calendar cal) throws SQLException {
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        int oid = field.getOID();
        if (this.isBinary(field)) {
            long millis;
            if (oid == 1184 || oid == 1114) {
                boolean hasTimeZone = oid == 1184;
                TimeZone tz = cal.getTimeZone();
                return this.connection.getTimestampUtils().toTimestampBin(tz, data, hasTimeZone);
            }
            if (oid == 1083 || oid == 1266) {
                millis = this.getTime(data, field, cal).getTime();
            } else if (oid == 1082) {
                millis = this.getDate(data, field, cal).getTime();
            } else {
                throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(oid), "timestamp"), PSQLState.DATA_TYPE_MISMATCH);
            }
            return new Timestamp(millis);
        }
        String string = this.getString(data, field);
        if (oid == 1083 || oid == 1266) {
            return new Timestamp(this.connection.getTimestampUtils().toTime(cal, string).getTime());
        }
        return this.connection.getTimestampUtils().toTimestamp(cal, string);
    }

    private OffsetDateTime getOffsetDateTime(int i) throws SQLException {
        byte[] value = this.getRawValue(i);
        if (value == null) {
            return null;
        }
        int col = i - 1;
        int oid = this.fields[col].getOID();
        if (this.isBinary(i)) {
            if (oid == 1184 || oid == 1114) {
                return this.connection.getTimestampUtils().toOffsetDateTimeBin(value);
            }
            if (oid == 1266) {
                Time time = this.getTime(i);
                if (time == null) {
                    return null;
                }
                return this.connection.getTimestampUtils().toOffsetDateTime(time);
            }
            throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(oid), "timestamptz"), PSQLState.DATA_TYPE_MISMATCH);
        }
        String string = this.getString(i);
        if (oid == 1266) {
            Calendar cal = this.getDefaultCalendar();
            Time time = this.connection.getTimestampUtils().toTime(cal, string);
            return this.connection.getTimestampUtils().toOffsetDateTime(time);
        }
        return this.connection.getTimestampUtils().toOffsetDateTime(string);
    }

    private LocalDateTime getLocalDateTime(int i) throws SQLException {
        byte[] value = this.getRawValue(i);
        if (value == null) {
            return null;
        }
        int col = i - 1;
        int oid = this.fields[col].getOID();
        if (oid != 1114) {
            throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(oid), "timestamp"), PSQLState.DATA_TYPE_MISMATCH);
        }
        if (this.isBinary(i)) {
            return this.connection.getTimestampUtils().toLocalDateTimeBin(value);
        }
        String string = this.getString(i);
        return this.connection.getTimestampUtils().toLocalDateTime(string);
    }

    @Override
    public java.sql.Date getDate(String c, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(c), cal);
    }

    @Override
    public Time getTime(String c, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(c), cal);
    }

    @Override
    public Timestamp getTimestamp(String c, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(c), cal);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchdirection;
    }

    public Object getObjectImpl(String columnName, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(this.findColumn(columnName), map);
    }

    public Object getObjectImpl(int i, Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        if (map == null || map.isEmpty()) {
            return this.getObject(i);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return 0;
        }
        int rows_size = this.rows.size();
        if (this.current_row < 0 || this.current_row >= rows_size) {
            return 0;
        }
        return this.row_offset + this.current_row + 1;
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.statement;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return this.resultsettype;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        int rows_size = this.rows.size();
        if (this.row_offset + rows_size == 0) {
            return false;
        }
        return this.current_row >= rows_size;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        return this.row_offset + this.current_row < 0 && !this.rows.isEmpty();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        int rows_size = this.rows.size();
        if (this.row_offset + rows_size == 0) {
            return false;
        }
        return this.row_offset + this.current_row == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        int rows_size = this.rows.size();
        if (rows_size == 0) {
            return false;
        }
        if (this.current_row != rows_size - 1) {
            return false;
        }
        if (this.cursor == null) {
            return true;
        }
        if (this.maxRows > 0 && this.row_offset + this.current_row == this.maxRows) {
            return true;
        }
        this.row_offset += rows_size - 1;
        int fetchRows = this.fetchSize;
        if (this.maxRows != 0 && (fetchRows == 0 || this.row_offset + fetchRows > this.maxRows)) {
            fetchRows = this.maxRows - this.row_offset;
        }
        this.connection.getQueryExecutor().fetch(this.cursor, new CursorResultHandler(), fetchRows);
        this.rows.add(0, this.this_row);
        this.current_row = 0;
        return this.rows.size() == 1;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkScrollable();
        int rows_size = this.rows.size();
        if (rows_size <= 0) {
            return false;
        }
        this.current_row = rows_size - 1;
        this.initRowBuffer();
        this.onInsertRow = false;
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkScrollable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("CAN_NOT_USE_RELATIVE_MOVE_METHODS_ON_THE_INSERT_ROW", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.current_row - 1 < 0) {
            this.current_row = -1;
            this.this_row = null;
            this.rowBuffer = null;
            return false;
        }
        --this.current_row;
        this.initRowBuffer();
        return true;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkScrollable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("CAN_NOT_USE_RELATIVE_MOVE_METHODS_ON_THE_INSERT_ROW", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        return this.absolute(this.current_row + 1 + rows);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        switch (direction) {
            case 1000: {
                break;
            }
            case 1001: 
            case 1002: {
                this.checkScrollable();
                break;
            }
            default: {
                throw new PSQLException(GT.tr("INVALID_FETCH_DIRECTION_CONSTANT", direction), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
        this.fetchdirection = direction;
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("INVALID_CURSOR_STATE_CAN_NOT_CALL_METHOD", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.clearRowBuffer(true);
        }
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("CAN_NOT_DELETE_ROW_ON_THE_INSERT_ROW", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isBeforeFirst()) {
            throw new PSQLException(GT.tr("CAN_NOT_DELETE_DATA_BEFORE_START_OF_THE_RESULT_SET", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isAfterLast()) {
            throw new PSQLException(GT.tr("CAN_NOT_DELETE_DATA_AFTER_END_OF_THE_RESULT_SET", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.rows.isEmpty()) {
            throw new PSQLException(GT.tr("NO_DATA_IN_THE_RESULT_SET", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        int numKeys = this.primaryKeys.size();
        if (this.deleteStatement == null) {
            StringBuilder deleteSQL = new StringBuilder("DELETE FROM ").append(this.onlyTable).append(this.tableName).append(" where ");
            for (int i = 0; i < numKeys; ++i) {
                Utils.escapeIdentifier(deleteSQL, this.primaryKeys.get((int)i).name, this.connection.getCompatibilityMode());
                deleteSQL.append(" = ?");
                if (i >= numKeys - 1) continue;
                deleteSQL.append(" and ");
            }
            this.deleteStatement = this.connection.prepareStatement(deleteSQL.toString());
        }
        this.deleteStatement.clearParameters();
        for (int i = 0; i < numKeys; ++i) {
            this.deleteStatement.setObject(i + 1, this.primaryKeys.get(i).getValue());
        }
        this.deleteStatement.executeUpdate();
        this.rows.remove(this.current_row);
        --this.current_row;
        this.moveToCurrentRow();
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        this.checkUpdateable();
        if (!this.onInsertRow) {
            throw new PSQLException(GT.tr("NOT_ON_THE_INSERT_ROW", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.updateValues.isEmpty()) {
            throw new PSQLException(GT.tr("You must specify at least one column value to insert a row.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        StringBuilder insertSQL = new StringBuilder("INSERT INTO ").append(this.tableName).append(" (");
        StringBuilder paramSQL = new StringBuilder(") values (");
        Iterator<String> columnNames = this.updateValues.keySet().iterator();
        int numColumns = this.updateValues.size();
        int i = 0;
        while (columnNames.hasNext()) {
            String columnName = columnNames.next();
            Utils.escapeIdentifier(insertSQL, columnName, this.connection.getCompatibilityMode());
            if (i < numColumns - 1) {
                insertSQL.append(", ");
                paramSQL.append("?,");
            } else {
                paramSQL.append("?)");
            }
            ++i;
        }
        insertSQL.append(paramSQL.toString());
        this.insertStatement = this.connection.prepareStatement(insertSQL.toString());
        Iterator<Object> values = this.updateValues.values().iterator();
        int i2 = 1;
        while (values.hasNext()) {
            this.insertStatement.setObject(i2, values.next());
            ++i2;
        }
        this.insertStatement.executeUpdate();
        if (this.usingOID) {
            long insertedOID = ((PgStatement)((Object)this.insertStatement)).getLastOID();
            this.updateValues.put("oid", insertedOID);
        }
        this.updateRowBuffer();
        this.rows.add(this.rowBuffer);
        this.this_row = this.rowBuffer;
        this.clearRowBuffer(false);
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        this.checkUpdateable();
        if (this.current_row < 0 || this.current_row >= this.rows.size()) {
            this.this_row = null;
            this.rowBuffer = null;
        } else {
            this.initRowBuffer();
        }
        this.onInsertRow = false;
        this.doingUpdates = false;
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        this.checkUpdateable();
        if (this.insertStatement != null) {
            this.insertStatement = null;
        }
        this.clearRowBuffer(false);
        this.onInsertRow = true;
        this.doingUpdates = false;
    }

    private synchronized void clearRowBuffer(boolean copyCurrentRow) throws SQLException {
        this.rowBuffer = new byte[this.fields.length][];
        if (copyCurrentRow) {
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        }
        this.updateValues.clear();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        try {
            int n;
            InputStreamReader reader = new InputStreamReader(x, "ASCII");
            char[] data = new char[length];
            int numRead = 0;
            while ((n = reader.read(data, numRead, length - numRead)) != -1 && (numRead += n) != length) {
            }
            this.updateString(columnIndex, new String(data, 0, numRead));
        }
        catch (UnsupportedEncodingException uee) {
            throw new PSQLException(GT.tr("THE_ENCODING_OF_JVM_CLAIMS_UNSUPPORTED", "ASCII"), PSQLState.UNEXPECTED_ERROR, (Throwable)uee);
        }
        catch (IOException ie) {
            throw new PSQLException(GT.tr("PROVIDED_INPUT_STREAM_FAILED", new Object[0]), null, (Throwable)ie);
        }
    }

    @Override
    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        byte[] data = new byte[length];
        int numRead = 0;
        try {
            int n;
            while ((n = x.read(data, numRead, length - numRead)) != -1 && (numRead += n) != length) {
            }
        }
        catch (IOException ie) {
            throw new PSQLException(GT.tr("PROVIDED_INPUT_STREAM_FAILED", new Object[0]), null, (Throwable)ie);
        }
        if (numRead == length) {
            this.updateBytes(columnIndex, data);
        } else {
            byte[] data2 = new byte[numRead];
            System.arraycopy(data, 0, data2, 0, numRead);
            this.updateBytes(columnIndex, data2);
        }
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateValue(columnIndex, String.valueOf(x));
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        try {
            int n;
            char[] data = new char[length];
            int numRead = 0;
            while ((n = x.read(data, numRead, length - numRead)) != -1 && (numRead += n) != length) {
            }
            this.updateString(columnIndex, new String(data, 0, numRead));
        }
        catch (IOException ie) {
            throw new PSQLException(GT.tr("PROVIDED_READER_FAILED", new Object[0]), null, (Throwable)ie);
        }
    }

    @Override
    public synchronized void updateDate(int columnIndex, java.sql.Date x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        this.updateValue(columnIndex, Float.valueOf(x));
    }

    @Override
    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        String columnTypeName = this.getPGType(columnIndex);
        this.updateValue(columnIndex, new NullObject(columnTypeName));
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.updateObject(columnIndex, x);
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("INVALID_CURSOR_STATE_CAN_NOT_REFRESH_ROW", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isBeforeFirst() || this.isAfterLast() || this.rows.isEmpty()) {
            return;
        }
        StringBuilder selectSQL = new StringBuilder("select ");
        ResultSetMetaData rsmd = this.getMetaData();
        PGResultSetMetaData pgmd = (PGResultSetMetaData)((Object)rsmd);
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            if (i > 1) {
                selectSQL.append(", ");
            }
            Utils.escapeIdentifier(selectSQL, pgmd.getBaseColumnName(i), this.connection.getCompatibilityMode());
        }
        selectSQL.append(" from ").append(this.onlyTable).append(this.tableName).append(" where ");
        int numKeys = this.primaryKeys.size();
        for (int i = 0; i < numKeys; ++i) {
            PrimaryKey primaryKey = this.primaryKeys.get(i);
            Utils.escapeIdentifier(selectSQL, primaryKey.name, this.connection.getCompatibilityMode());
            selectSQL.append(" = ?");
            if (i >= numKeys - 1) continue;
            selectSQL.append(" and ");
        }
        String sqlText = selectSQL.toString();
        if (this.connection.getLogger().isDebugEnabled()) {
            this.connection.getLogger().debug("selecting " + sqlText);
        }
        this.selectStatement = this.connection.prepareStatement(sqlText, 1004, 1008);
        int j = 0;
        int i = 1;
        while (j < numKeys) {
            this.selectStatement.setObject(i, this.primaryKeys.get(j).getValue());
            ++j;
            ++i;
        }
        PgResultSet rs = (PgResultSet)this.selectStatement.executeQuery();
        if (rs.next()) {
            this.rowBuffer = rs.this_row;
        }
        this.rows.set(this.current_row, this.rowBuffer);
        this.this_row = this.rowBuffer;
        this.connection.getLogger().debug("done updates");
        rs.close();
        this.selectStatement.close();
        this.selectStatement = null;
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("CAN_NOT_UPDATE_ROW_ON_THE_INSERT_ROW", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isBeforeFirst() || this.isAfterLast() || this.rows.isEmpty()) {
            throw new PSQLException(GT.tr("CAN_NOT_UPDATE_THE_RESULT_SET", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (!this.doingUpdates) {
            return;
        }
        StringBuilder updateSQL = new StringBuilder("UPDATE " + this.onlyTable + this.tableName + " SET  ");
        int numColumns = this.updateValues.size();
        Iterator<String> columns = this.updateValues.keySet().iterator();
        int i = 0;
        while (columns.hasNext()) {
            String column = columns.next();
            Utils.escapeIdentifier(updateSQL, column, this.connection.getCompatibilityMode());
            updateSQL.append(" = ?");
            if (i < numColumns - 1) {
                updateSQL.append(", ");
            }
            ++i;
        }
        updateSQL.append(" WHERE ");
        int numKeys = this.primaryKeys.size();
        for (int i2 = 0; i2 < numKeys; ++i2) {
            PrimaryKey primaryKey = this.primaryKeys.get(i2);
            Utils.escapeIdentifier(updateSQL, primaryKey.name, this.connection.getCompatibilityMode());
            updateSQL.append(" = ?");
            if (i2 >= numKeys - 1) continue;
            updateSQL.append(" and ");
        }
        String sqlText = updateSQL.toString();
        if (this.connection.getLogger().isDebugEnabled()) {
            this.connection.getLogger().debug("updating " + sqlText);
        }
        this.updateStatement = this.connection.prepareStatement(sqlText);
        int i3 = 0;
        for (Object o : this.updateValues.values()) {
            this.updateStatement.setObject(i3 + 1, o);
            ++i3;
        }
        int j = 0;
        while (j < numKeys) {
            this.updateStatement.setObject(i3 + 1, this.primaryKeys.get(j).getValue());
            ++j;
            ++i3;
        }
        this.updateStatement.executeUpdate();
        this.updateStatement.close();
        this.updateStatement = null;
        this.updateRowBuffer();
        this.connection.getLogger().debug("copying data");
        System.arraycopy(this.rowBuffer, 0, this.this_row, 0, this.rowBuffer.length);
        this.rows.set(this.current_row, this.rowBuffer);
        this.connection.getLogger().debug("done updates");
        this.updateValues.clear();
        this.doingUpdates = false;
    }

    @Override
    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateDate(String columnName, java.sql.Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    boolean isUpdateable() throws SQLException {
        this.checkClosed();
        if (this.resultsetconcurrency == 1007) {
            throw new PSQLException(GT.tr("RESULT_SETS_WITH_CONCURRENCY_CAN_NOT_BE_UPDATED", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.updateable) {
            return true;
        }
        this.connection.getLogger().debug("checking if rs is updateable");
        this.parseQuery();
        if (!this.singleTable) {
            this.connection.getLogger().debug("not a single table");
            return false;
        }
        this.connection.getLogger().debug("getting primary keys");
        this.primaryKeys = new ArrayList<PrimaryKey>();
        this.usingOID = false;
        int oidIndex = this.findColumnIndex("oid");
        int i = 0;
        int numPKcolumns = 0;
        if (oidIndex > 0) {
            ++i;
            ++numPKcolumns;
            this.primaryKeys.add(new PrimaryKey(oidIndex, "oid"));
            this.usingOID = true;
        } else {
            String[] s = PgResultSet.quotelessTableName(this.tableName);
            String quotelessTableName = s[0];
            String quotelessSchemaName = s[1];
            ResultSet rs = this.connection.getMetaData().getPrimaryKeys("", quotelessSchemaName, quotelessTableName);
            while (rs.next()) {
                ++numPKcolumns;
                String columnName = rs.getString(4);
                int index = this.findColumnIndex(columnName);
                if (index <= 0) continue;
                ++i;
                this.primaryKeys.add(new PrimaryKey(index, columnName));
            }
            rs.close();
        }
        this.connection.getLogger().debug("no of keys=" + i);
        if (i < 1) {
            throw new PSQLException(GT.tr("NO_PRIMARY_KEY_FOUND_FOR_TABLE", this.tableName), PSQLState.DATA_ERROR);
        }
        this.updateable = i == numPKcolumns;
        this.connection.getLogger().debug("checking primary key " + this.updateable);
        return this.updateable;
    }

    public static String[] quotelessTableName(String fullname) {
        String[] parts = new String[]{null, ""};
        StringBuilder acc = new StringBuilder();
        boolean betweenQuotes = false;
        block4: for (int i = 0; i < fullname.length(); ++i) {
            char c = fullname.charAt(i);
            switch (c) {
                case '\"': {
                    if (i < fullname.length() - 1 && fullname.charAt(i + 1) == '\"') {
                        ++i;
                        acc.append(c);
                        continue block4;
                    }
                    betweenQuotes = !betweenQuotes;
                    continue block4;
                }
                case '.': {
                    if (betweenQuotes) {
                        acc.append(c);
                        continue block4;
                    }
                    parts[1] = acc.toString();
                    acc = new StringBuilder();
                    continue block4;
                }
                default: {
                    acc.append(betweenQuotes ? c : Character.toLowerCase(c));
                }
            }
        }
        parts[0] = acc.toString();
        return parts;
    }

    private void parseQuery() {
        String l_sql = this.originalQuery.toString(null);
        StringTokenizer st = new StringTokenizer(l_sql, " \r\t\n");
        boolean tableFound = false;
        boolean tablesChecked = false;
        String name = "";
        this.singleTable = true;
        while (!tableFound && !tablesChecked && st.hasMoreTokens()) {
            name = st.nextToken();
            if (!"from".equalsIgnoreCase(name)) continue;
            this.tableName = st.nextToken();
            if ("only".equalsIgnoreCase(this.tableName)) {
                this.tableName = st.nextToken();
                this.onlyTable = "ONLY ";
            }
            tableFound = true;
        }
    }

    private void updateRowBuffer() throws SQLException {
        block9: for (Map.Entry<String, Object> entry : this.updateValues.entrySet()) {
            int columnIndex = this.findColumn(entry.getKey()) - 1;
            Object valueObject = entry.getValue();
            if (valueObject instanceof PGobject) {
                String value = ((PGobject)valueObject).getValue();
                this.rowBuffer[columnIndex] = value == null ? null : this.connection.encodeString(value);
                continue;
            }
            switch (this.getSQLType(columnIndex + 1)) {
                case 91: {
                    this.rowBuffer[columnIndex] = this.connection.encodeString(this.connection.getTimestampUtils().toString(this.getDefaultCalendar(), (java.sql.Date)valueObject));
                    continue block9;
                }
                case 92: {
                    this.rowBuffer[columnIndex] = this.connection.encodeString(this.connection.getTimestampUtils().toString(this.getDefaultCalendar(), (Time)valueObject));
                    continue block9;
                }
                case 93: {
                    this.rowBuffer[columnIndex] = this.connection.encodeString(this.connection.getTimestampUtils().toString(this.getDefaultCalendar(), (Timestamp)valueObject));
                    continue block9;
                }
                case 0: {
                    continue block9;
                }
                case -4: 
                case -3: 
                case -2: {
                    if (this.isBinary(columnIndex + 1)) {
                        this.rowBuffer[columnIndex] = (byte[])valueObject;
                        continue block9;
                    }
                    try {
                        this.rowBuffer[columnIndex] = PGbytea.toPGString((byte[])valueObject).getBytes("ISO-8859-1");
                        continue block9;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new PSQLException(GT.tr("THE_ENCODING_OF_JVM_CLAIMS_UNSUPPORTED", "ISO-8859-1"), PSQLState.UNEXPECTED_ERROR, (Throwable)e);
                    }
                }
            }
            this.rowBuffer[columnIndex] = this.connection.encodeString(String.valueOf(valueObject));
        }
    }

    public BaseStatement getPGStatement() {
        return this.statement;
    }

    @Override
    public String getRefCursor() {
        return this.refCursorName;
    }

    private void setRefCursor(String refCursorName) {
        this.refCursorName = refCursorName;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows >= 0 || rows == Integer.MIN_VALUE && this.connection.isEnableStreamingQuery()) {
            this.fetchSize = rows;
            return;
        }
        throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("CAN_NOT_USE_RELATIVE_MOVE_METHODS_ON_THE_INSERT_ROW", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.current_row + 1 >= this.rows.size()) {
            if (this.enableStreamingQuery) {
                this.checkClosed();
                this.current_row = 0;
                if (this.connection.getQueryExecutor().isOccupied()) {
                    try {
                        this.connection.getQueryExecutor().fetch(null, new CursorResultHandler(), this.fetchSize);
                    }
                    catch (PSQLException e) {
                        this.sqlExecuteState = e.getSQLState();
                        throw e;
                    }
                }
                if (this.rows == null || this.rows.isEmpty()) {
                    this.this_row = null;
                    this.rowBuffer = null;
                    return false;
                }
                this.initRowBuffer();
                return true;
            }
            if (this.cursor == null || this.maxRows > 0 && this.row_offset + this.rows.size() >= this.maxRows) {
                this.current_row = this.rows.size();
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
            this.row_offset += this.rows.size();
            int fetchRows = this.fetchSize;
            if (this.maxRows != 0 && (fetchRows == 0 || this.row_offset + fetchRows > this.maxRows)) {
                fetchRows = this.maxRows - this.row_offset;
            }
            this.connection.getQueryExecutor().fetch(this.cursor, new CursorResultHandler(), fetchRows);
            this.current_row = 0;
            if (this.rows.isEmpty()) {
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
        } else {
            ++this.current_row;
        }
        this.initRowBuffer();
        return true;
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.enableStreamingQuery && !this.isClosed) {
                this.releaseSocketStream();
            }
            this.rows = null;
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
            }
        }
        finally {
            ((PgStatement)this.statement).checkCompletion();
        }
    }

    protected void releaseSocketStream() throws PSQLException {
        this.connection.getQueryExecutor().setOccupied(false);
        this.isClosed = true;
        if (!this.rows.isEmpty() && !PSQLState.QUERY_CANCELED.getState().equals(this.sqlExecuteState)) {
            this.connection.getQueryExecutor().executeReleaseMemory(8192);
        }
        this.sqlExecuteState = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNullFlag;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (this.connection.getLogger().isTraceEnabled()) {
            this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getString columnIndex: " + columnIndex);
        }
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        return this.getString(this.this_row[columnIndex - 1], this.fields[columnIndex - 1]);
    }

    protected String getString(byte[] data, Field field) throws SQLException {
        if (this.isBinary(field) && this.getSQLType(field) != 12) {
            Object obj = this.getObjectFromByteArray(data, field);
            if (obj == null) {
                obj = this.getObject(data, field);
                if (obj == null) {
                    return null;
                }
                return this.resultUppercase(obj.toString());
            }
            if (obj instanceof Date) {
                int oid = field.getOID();
                return this.connection.getTimestampUtils().timeToString((Date)obj, oid == 1184 || oid == 1266);
            }
            if ("hstore".equals(this.getPGType(field))) {
                return HStoreConverter.toString((Map)obj);
            }
            return this.resultUppercase(this.trimString(field, obj.toString()));
        }
        if (field.getOID() == 1038 && this.connection.isYearAsDateType()) {
            Calendar calendar = Calendar.getInstance(this.getDefaultCalendar().getTimeZone());
            calendar.set(this.getInt(data, field), 0, 1);
            return new java.sql.Date(calendar.getTimeInMillis()).toString();
        }
        Encoding encoding = this.connection.getEncoding();
        try {
            if (field.getOID() == 17) {
                Charset charset = Charset.forName(encoding.name());
                return this.resultUppercase(this.trimString(field, charset.decode(ByteBuffer.wrap(data)).toString()));
            }
            if (this.connection.getQueryExecutor().isSupportSpecialCharacter()) {
                return this.resultUppercase(this.trimString(field, new String(data, encoding.name())));
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new PSQLException(GT.tr("The JVM claims not to support the {0} encoding.", encoding), PSQLState.UNEXPECTED_ERROR, (Throwable)ex);
        }
        try {
            if (this.connection.getClientLogic() == null && ClientLogic.isClientLogicField(field.getOID())) {
                return this.resultUppercase(this.trimString(field, "\\x" + PgResultSet.bytesArrayToHexString(data).toLowerCase()));
            }
            return this.resultUppercase(this.trimString(field, encoding.decode(data)));
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Invalid character data was found. This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (this.connection.getLogger().isTraceEnabled()) {
            this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getBoolean columnIndex: " + columnIndex);
        }
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return false;
        }
        return this.getBoolean(this.this_row[columnIndex - 1], this.fields[columnIndex - 1]);
    }

    private boolean getBoolean(byte[] data, Field field) throws SQLException {
        if (data == null) {
            return false;
        }
        if (16 == field.getOID()) {
            return 1 == data.length && 116 == data[0];
        }
        if (this.isBinary(field)) {
            return BooleanTypeUtil.castToBoolean(this.readDoubleValue(data, field.getOID(), "boolean"));
        }
        return BooleanTypeUtil.castToBoolean(this.getString(data, field));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        if (this.connection.getLogger().isTraceEnabled()) {
            this.connection.getLogger().trace("  getByte columnIndex: " + columnIndex);
        }
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return 0;
        }
        return this.getByte(this.this_row[columnIndex - 1], this.fields[columnIndex - 1]);
    }

    private byte getByte(byte[] data, Field field) throws SQLException {
        if (data == null) {
            return 0;
        }
        if (this.isBinary(field)) {
            return (byte)this.readLongValue(data, field.getOID(), -128L, 127L, "byte");
        }
        String s = this.getString(data, field);
        if (s != null) {
            if ((s = s.trim()).isEmpty()) {
                return 0;
            }
            try {
                return Byte.parseByte(s);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(BYTEMAX);
                    int lt = i.compareTo(BYTEMIN);
                    if (gt > 0 || lt < 0) {
                        throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "byte", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return i.byteValue();
                }
                catch (NumberFormatException ex) {
                    throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "byte", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        if (this.connection.getLogger().isTraceEnabled()) {
            this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getShort columnIndex: " + columnIndex);
        }
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return 0;
        }
        return this.getShort(this.this_row[columnIndex - 1], this.fields[columnIndex - 1]);
    }

    private short getShort(byte[] data, Field field) throws SQLException {
        if (data == null) {
            return 0;
        }
        if (this.isBinary(field)) {
            int oid = field.getOID();
            if (oid == 21) {
                return ByteConverter.int2(data, 0);
            }
            return (short)this.readLongValue(data, oid, -32768L, 32767L, "short");
        }
        if (field.getOID() == 1038) {
            Encoding encoding = this.connection.getEncoding();
            try {
                return PgResultSet.toShort(this.trimString(field, new String(data, encoding.name())));
            }
            catch (UnsupportedEncodingException ex) {
                throw new PSQLException(GT.tr("The JVM claims not to support the {0} encoding.", encoding), PSQLState.UNEXPECTED_ERROR, (Throwable)ex);
            }
        }
        return PgResultSet.toShort(this.getFixedString(data, field));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        if (this.connection.getLogger().isTraceEnabled()) {
            this.connection.getLogger().trace("  getInt columnIndex: " + columnIndex);
        }
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return 0;
        }
        return this.getInt(this.this_row[columnIndex - 1], this.fields[columnIndex - 1]);
    }

    private int getInt(byte[] data, Field field) throws SQLException {
        block6: {
            if (data == null) {
                return 0;
            }
            if (this.isBinary(field)) {
                int oid = field.getOID();
                if (oid == 23) {
                    return ByteConverter.int4(data, 0);
                }
                return (int)this.readLongValue(data, oid, Integer.MIN_VALUE, Integer.MAX_VALUE, "int");
            }
            Encoding encoding = this.connection.getEncoding();
            if (encoding.hasAsciiNumbers()) {
                try {
                    return this.getFastInt(data);
                }
                catch (NumberFormatException ex) {
                    if (!this.connection.getLogger().isTraceEnabled()) break block6;
                    this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "] function getFastInt() failed.");
                }
            }
        }
        return PgResultSet.toInt(this.getFixedString(data, field));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        if (this.connection.getLogger().isTraceEnabled()) {
            this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getLong columnIndex: " + columnIndex);
        }
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return 0L;
        }
        return this.getLong(this.this_row[columnIndex - 1], this.fields[columnIndex - 1]);
    }

    private long getLong(byte[] data, Field field) throws SQLException {
        block6: {
            if (data == null) {
                return 0L;
            }
            if (this.isBinary(field)) {
                int oid = field.getOID();
                if (oid == 20) {
                    return ByteConverter.int8(data, 0);
                }
                return this.readLongValue(data, oid, Long.MIN_VALUE, Long.MAX_VALUE, "long");
            }
            Encoding encoding = this.connection.getEncoding();
            if (encoding.hasAsciiNumbers()) {
                try {
                    return this.getFastLong(data);
                }
                catch (NumberFormatException ex) {
                    if (!this.connection.getLogger().isTraceEnabled()) break block6;
                    this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "] function getFastLong() failed.");
                }
            }
        }
        return PgResultSet.toLong(this.getFixedString(data, field));
    }

    private long getFastLong(byte[] bytes) throws SQLException, NumberFormatException {
        int start;
        boolean neg;
        if (bytes.length == 0) {
            throw FAST_NUMBER_FAILED;
        }
        long val = 0L;
        if (bytes[0] == 45) {
            neg = true;
            start = 1;
            if (bytes.length == 1 || bytes.length > 19) {
                throw FAST_NUMBER_FAILED;
            }
        } else {
            start = 0;
            neg = false;
            if (bytes.length > 18) {
                throw FAST_NUMBER_FAILED;
            }
        }
        while (start < bytes.length) {
            byte b;
            if ((b = bytes[start++]) < 48 || b > 57) {
                throw FAST_NUMBER_FAILED;
            }
            val *= 10L;
            val += (long)(b - 48);
        }
        if (neg) {
            val = -val;
        }
        return val;
    }

    private int getFastInt(byte[] bytes) throws SQLException, NumberFormatException {
        int start;
        boolean neg;
        if (bytes.length == 0) {
            throw FAST_NUMBER_FAILED;
        }
        int val = 0;
        if (bytes[0] == 45) {
            neg = true;
            start = 1;
            if (bytes.length == 1 || bytes.length > 10) {
                throw FAST_NUMBER_FAILED;
            }
        } else {
            start = 0;
            neg = false;
            if (bytes.length > 9) {
                throw FAST_NUMBER_FAILED;
            }
        }
        while (start < bytes.length) {
            byte b;
            if ((b = bytes[start++]) < 48 || b > 57) {
                throw FAST_NUMBER_FAILED;
            }
            val *= 10;
            val += b - 48;
        }
        if (neg) {
            val = -val;
        }
        return val;
    }

    private BigDecimal getFastBigDecimal(byte[] bytes) throws SQLException, NumberFormatException {
        int numNonSignChars;
        int start;
        boolean neg;
        if (bytes.length == 0) {
            throw FAST_NUMBER_FAILED;
        }
        int scale = 0;
        long val = 0L;
        if (bytes[0] == 45) {
            neg = true;
            start = 1;
            if (bytes.length == 1 || bytes.length > 19) {
                throw FAST_NUMBER_FAILED;
            }
        } else {
            start = 0;
            neg = false;
            if (bytes.length > 18) {
                throw FAST_NUMBER_FAILED;
            }
        }
        int periodsSeen = 0;
        while (start < bytes.length) {
            byte b;
            if ((b = bytes[start++]) < 48 || b > 57) {
                if (b == 46) {
                    scale = bytes.length - start;
                    ++periodsSeen;
                    continue;
                }
                throw FAST_NUMBER_FAILED;
            }
            val *= 10L;
            val += (long)(b - 48);
        }
        int n = numNonSignChars = neg ? bytes.length - 1 : bytes.length;
        if (periodsSeen > 1 || periodsSeen == numNonSignChars) {
            throw FAST_NUMBER_FAILED;
        }
        if (neg) {
            val = -val;
        }
        return BigDecimal.valueOf(val, scale);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getFloat columnIndex: " + columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return 0.0f;
        }
        return this.getFloat(this.this_row[columnIndex - 1], this.fields[columnIndex - 1]);
    }

    private float getFloat(byte[] data, Field field) throws SQLException {
        if (data == null) {
            return 0.0f;
        }
        if (this.isBinary(field)) {
            int oid = field.getOID();
            if (oid == 700) {
                return ByteConverter.float4(data, 0);
            }
            return (float)this.readDoubleValue(data, oid, "float");
        }
        return PgResultSet.toFloat(this.getFixedString(data, field));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getDouble columnIndex: " + columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return 0.0;
        }
        return this.getDouble(this.this_row[columnIndex - 1], this.fields[columnIndex - 1]);
    }

    private double getDouble(byte[] data, Field field) throws SQLException {
        if (data == null) {
            return 0.0;
        }
        if (this.isBinary(field)) {
            int oid = field.getOID();
            if (oid == 701) {
                return ByteConverter.float8(data, 0);
            }
            return this.readDoubleValue(data, oid, "double");
        }
        return PgResultSet.toDouble(this.getFixedString(data, field));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getBigDecimal columnIndex: " + columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        return this.getBigDecimal(this.this_row[columnIndex - 1], this.fields[columnIndex - 1], scale);
    }

    private BigDecimal getBigDecimal(byte[] data, Field field, int scale) throws SQLException {
        int sqlType;
        if (this.isBinary(field) && (sqlType = this.getSQLType(field)) != 2 && sqlType != 3) {
            Object obj = this.getObjectFromByteArray(data, field);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Long || obj instanceof Integer || obj instanceof Byte) {
                BigDecimal res = BigDecimal.valueOf(((Number)obj).longValue());
                res = this.scaleBigDecimal(res, scale);
                return res;
            }
            return this.toBigDecimal(this.trimMoney(String.valueOf(obj)), scale);
        }
        Encoding encoding = this.connection.getEncoding();
        if (encoding.hasAsciiNumbers()) {
            try {
                BigDecimal res = this.getFastBigDecimal(data);
                res = this.scaleBigDecimal(res, scale);
                return res;
            }
            catch (NumberFormatException ex) {
                this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "] function getFastBigDecimal() failed.");
            }
        }
        return this.toBigDecimal(this.getFixedString(data, field), scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getBytes columnIndex: " + columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        return this.getBytes(this.this_row[columnIndex - 1], this.fields[columnIndex - 1]);
    }

    private byte[] getBytes(byte[] data, Field field) throws SQLException {
        if (this.isBinary(field)) {
            return data;
        }
        int oid = field.getOID();
        if (oid == 17) {
            return this.trimBytes(PGbytea.toBytes(data), field);
        }
        if (oid == 88) {
            return this.toBytes(this.getString(data, field));
        }
        return this.trimBytes(data, field);
    }

    @Override
    public java.sql.Date getDate(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getDate columnIndex: " + columnIndex);
        return this.getDate(columnIndex, null);
    }

    private java.sql.Date getDate(byte[] data, Field field) throws SQLException {
        return this.getDate(data, field, null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getTime columnIndex: " + columnIndex);
        return this.getTime(columnIndex, null);
    }

    private Time getTime(byte[] data, Field field) throws SQLException {
        return this.getTime(data, field, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getTimestamp columnIndex: " + columnIndex);
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getAsciiStream columnIndex: " + columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        try {
            return new ByteArrayInputStream(this.getString(columnIndex).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new PSQLException(GT.tr("THE_ENCODING_OF_JVM_CLAIMS_UNSUPPORTED", "ASCII"), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getUnicodeStream columnIndex: " + columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        try {
            return new ByteArrayInputStream(this.getString(columnIndex).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new PSQLException(GT.tr("THE_ENCODING_OF_JVM_CLAIMS_UNSUPPORTED", "UTF-8"), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getBinaryStream columnIndex: " + columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        byte[] b = this.getBytes(columnIndex);
        if (b != null) {
            return new ByteArrayInputStream(b);
        }
        return null;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public java.sql.Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName), null);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName), null);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), null);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    protected void addWarning(SQLWarning warnings) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warnings);
        } else {
            this.warnings = warnings;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getObject columnIndex: " + columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        Field field = this.fields[columnIndex - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        if (this.getPGType(columnIndex).equals("blob") && !this.connection.isUseGsClobBlobClass()) {
            return this.toBytes(this.getString(columnIndex));
        }
        Object result = this.internalGetObject(columnIndex, field);
        if (result != null) {
            return result;
        }
        if ("year".equals(this.getPGType(columnIndex))) {
            return this.connection.isYearAsDateType() ? this.getDate(columnIndex) : Integer.valueOf(this.getInt(columnIndex));
        }
        if (this.isBinary(columnIndex)) {
            return this.connection.getObject(this.getPGType(columnIndex), null, this.this_row[columnIndex - 1], field);
        }
        if (this.isQueryTypeStruct()) {
            return new PGobject(this.getString(columnIndex), this.fields[1].getTypeNode(), this.connection);
        }
        return this.connection.getObject(this.getPGType(columnIndex), this.getString(columnIndex), null, field);
    }

    private boolean isQueryTypeStruct() {
        return this.fields.length >= 2 && this.fields[1] != null && this.fields[1].getTypeNode() != null && !this.fields[1].getTypeNode().isTableType() && !this.fields[1].getTypeNode().isBaseType();
    }

    private Object getObject(byte[] data, Field field) throws SQLException {
        if ("blob".equals(this.getPGType(field))) {
            return this.toBytes(this.getString(data, field));
        }
        Object result = this.getObjectFromByteArray(data, field);
        if (result != null) {
            return result;
        }
        if (this.isBinary(field)) {
            return this.connection.getObject(this.getPGType(field), null, data);
        }
        return this.connection.getObject(this.getPGType(field), this.getString(data, field), null);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        this.checkClosed();
        int col = this.findColumnIndex(columnName);
        if (col == 0) {
            throw new PSQLException(GT.tr("COLUMN_NAME_WAS_NOT_FOUND_IN_THE_RESULT_SET", columnName), PSQLState.UNDEFINED_COLUMN);
        }
        return col;
    }

    public static Map<String, Integer> createColumnNameIndexMap(Field[] fields, boolean isSanitiserDisabled) {
        HashMap<String, Integer> columnNameIndexMap = new HashMap<String, Integer>(fields.length * 2);
        for (int i = fields.length - 1; i >= 0; --i) {
            String columnLabel = fields[i].getColumnLabel();
            if (isSanitiserDisabled) {
                columnNameIndexMap.put(columnLabel, i + 1);
                continue;
            }
            columnNameIndexMap.put(columnLabel.toLowerCase(Locale.US), i + 1);
        }
        return columnNameIndexMap;
    }

    private int findColumnIndex(String columnName) {
        Integer index;
        if (this.columnNameIndexMap == null) {
            if (this.originalQuery != null) {
                this.columnNameIndexMap = this.originalQuery.getResultSetColumnNameIndexMap();
            }
            if (this.columnNameIndexMap == null) {
                this.columnNameIndexMap = PgResultSet.createColumnNameIndexMap(this.fields, this.connection.isColumnSanitiserDisabled());
            }
        }
        if ((index = this.columnNameIndexMap.get(columnName)) != null) {
            return index;
        }
        index = this.columnNameIndexMap.get(columnName.toLowerCase(Locale.US));
        if (index != null) {
            this.columnNameIndexMap.put(columnName, index);
            return index;
        }
        index = this.columnNameIndexMap.get(columnName.toUpperCase(Locale.US));
        if (index != null) {
            this.columnNameIndexMap.put(columnName, index);
            return index;
        }
        return 0;
    }

    public int getColumnOID(int field) {
        return this.fields[field - 1].getOID();
    }

    public String getFixedString(int col) throws SQLException {
        return this.trimMoney(this.getString(col));
    }

    private String getFixedString(byte[] data, Field field) throws SQLException {
        return this.trimMoney(this.getString(data, field));
    }

    private String trimMoney(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() < 2) {
            return s;
        }
        char ch = s.charAt(0);
        if (ch > '-') {
            return s;
        }
        if (ch == '(') {
            s = "-" + PGtokenizer.removePara(s).substring(1);
        } else if (ch == '$') {
            s = s.substring(1);
        } else if (ch == '-' && s.charAt(1) == '$') {
            s = "-" + s.substring(2);
        }
        return s;
    }

    protected String getPGType(int column) throws SQLException {
        Field field = this.fields[column - 1];
        return this.getPGType(field);
    }

    private String getPGType(Field field) throws SQLException {
        this.initSqlType(field);
        return field.getPGType();
    }

    protected int getSQLType(int column) throws SQLException {
        Field field = this.fields[column - 1];
        return this.getSQLType(field);
    }

    private int getSQLType(Field field) throws SQLException {
        this.initSqlType(field);
        return field.getSQLType();
    }

    private void initSqlType(Field field) throws SQLException {
        if (field.isTypeInitialized()) {
            return;
        }
        TypeInfo typeInfo = this.connection.getTypeInfo();
        int oid = field.getOID();
        String pgType = typeInfo.getPGType(oid);
        if (this.connection.getClientLogic() != null && ClientLogic.isClientLogicField(oid) && field.getMod() > 0) {
            pgType = typeInfo.getPGType(field.getMod());
        }
        int sqlType = typeInfo.getSQLType(pgType);
        field.setSQLType(sqlType);
        field.setPGType(pgType);
    }

    private void checkUpdateable() throws SQLException {
        this.checkClosed();
        if (!this.isUpdateable()) {
            throw new PSQLException(GT.tr("RESULT_SET_IS_NOT_UPDATABLE", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.updateValues == null) {
            this.updateValues = new HashMap((int)((double)this.fields.length / 0.75), 0.75f);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.rows == null) {
            throw new PSQLException(GT.tr("RESULT_SET_IS_CLOSED", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    protected boolean isResultSetClosed() {
        return this.rows == null;
    }

    protected void checkColumnIndex(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            throw new PSQLException(GT.tr("COLUMN_INDEX_OUT_OF_RANGE", column, this.fields.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    protected byte[] getRawValue(int column) throws SQLException {
        this.checkClosed();
        if (this.this_row == null) {
            throw new PSQLException(GT.tr("RESULT_SET_NOT_POSITIONED_PROPERLY", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(column);
        byte[] bytes = this.this_row[column - 1];
        this.wasNullFlag = bytes == null;
        return bytes;
    }

    protected void checkResultSet(int column) throws SQLException {
        this.checkClosed();
        if (this.this_row == null) {
            throw new PSQLException(GT.tr("RESULT_SET_NOT_POSITIONED_PROPERLY", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(column);
        this.wasNullFlag = this.this_row[column - 1] == null;
    }

    protected boolean isBinary(int column) {
        return this.isBinary(this.fields[column - 1]);
    }

    private boolean isBinary(Field field) {
        ClientLogic clientLogic = this.connection.getClientLogic();
        if (clientLogic != null && ClientLogic.isClientLogicField(field.getOID())) {
            return false;
        }
        return field.getFormat() == 1;
    }

    public static short toShort(String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Short.parseShort(s);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(SHORTMAX);
                    int lt = i.compareTo(SHORTMIN);
                    if (gt > 0 || lt < 0) {
                        throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "short", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return i.shortValue();
                }
                catch (NumberFormatException ne) {
                    throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "short", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0;
    }

    public static int toInt(String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(INTMAX);
                    int lt = i.compareTo(INTMIN);
                    if (gt > 0 || lt < 0) {
                        throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "int", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return i.intValue();
                }
                catch (NumberFormatException ne) {
                    throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "int", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0;
    }

    public static long toLong(String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(LONGMAX);
                    int lt = i.compareTo(LONGMIN);
                    if (gt > 0 || lt < 0) {
                        throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "long", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return i.longValue();
                }
                catch (NumberFormatException ne) {
                    throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "long", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0L;
    }

    public static BigDecimal toBigDecimal(String s) throws SQLException {
        if (s == null) {
            return null;
        }
        try {
            s = s.trim();
            return new BigDecimal(s);
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "BigDecimal", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
    }

    public BigDecimal toBigDecimal(String s, int scale) throws SQLException {
        if (s == null) {
            return null;
        }
        BigDecimal val = PgResultSet.toBigDecimal(s);
        return this.scaleBigDecimal(val, scale);
    }

    private BigDecimal scaleBigDecimal(BigDecimal val, int scale) throws PSQLException {
        if (scale == -1) {
            return val;
        }
        try {
            if (this.connection.getStripTrailingZeros()) {
                return new BigDecimal(val.setScale(scale).stripTrailingZeros().toPlainString());
            }
            return val.setScale(scale);
        }
        catch (ArithmeticException e) {
            throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "BigDecimal", val), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
    }

    public static float toFloat(String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Float.parseFloat(s);
            }
            catch (NumberFormatException e) {
                throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "float", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            }
        }
        return 0.0f;
    }

    public static double toDouble(String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", "double", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            }
        }
        return 0.0;
    }

    private void initRowBuffer() {
        this.this_row = this.rows.get(this.current_row);
        if (this.resultsetconcurrency == 1008) {
            this.rowBuffer = new byte[this.this_row.length][];
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        } else {
            this.rowBuffer = null;
        }
    }

    private boolean isColumnTrimmable(Field field) throws SQLException {
        switch (this.getSQLType(field)) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private byte[] trimBytes(byte[] data, Field field) throws SQLException {
        if (this.maxFieldSize > 0 && data.length > this.maxFieldSize && this.isColumnTrimmable(field)) {
            byte[] l_bytes = new byte[this.maxFieldSize];
            System.arraycopy(data, 0, l_bytes, 0, this.maxFieldSize);
            return l_bytes;
        }
        return data;
    }

    private String trimString(Field field, String pString) throws SQLException {
        if (this.maxFieldSize > 0 && pString.length() > this.maxFieldSize && this.isColumnTrimmable(field)) {
            return pString.substring(0, this.maxFieldSize);
        }
        return pString;
    }

    private double readDoubleValue(byte[] bytes, int oid, String targetType) throws PSQLException {
        switch (oid) {
            case 21: {
                return ByteConverter.int2(bytes, 0);
            }
            case 23: {
                return ByteConverter.int4(bytes, 0);
            }
            case 20: {
                return ByteConverter.int8(bytes, 0);
            }
            case 700: {
                return ByteConverter.float4(bytes, 0);
            }
            case 701: {
                return ByteConverter.float8(bytes, 0);
            }
        }
        throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(oid), targetType), PSQLState.DATA_TYPE_MISMATCH);
    }

    private long readLongValue(byte[] bytes, int oid, long minVal, long maxVal, String targetType) throws PSQLException {
        long val;
        switch (oid) {
            case 21: {
                val = ByteConverter.int2(bytes, 0);
                break;
            }
            case 23: {
                val = ByteConverter.int4(bytes, 0);
                break;
            }
            case 20: {
                val = ByteConverter.int8(bytes, 0);
                break;
            }
            case 700: {
                val = (long)ByteConverter.float4(bytes, 0);
                break;
            }
            case 701: {
                val = (long)ByteConverter.float8(bytes, 0);
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(oid), targetType), PSQLState.DATA_TYPE_MISMATCH);
            }
        }
        if (val < minVal || val > maxVal) {
            throw new PSQLException(GT.tr("NUMERIC_VALUE_OUT_OF_RANGE", targetType, val), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return val;
    }

    protected void updateValue(int columnIndex, Object value) throws SQLException {
        this.checkUpdateable();
        if (!this.onInsertRow && (this.isBeforeFirst() || this.isAfterLast() || this.rows.isEmpty())) {
            throw new PSQLException(GT.tr("CAN_NOT_UPDATE_THE_RESULT_SET", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(columnIndex);
        boolean bl = this.doingUpdates = !this.onInsertRow;
        if (value == null) {
            this.updateNull(columnIndex);
        } else {
            PGResultSetMetaData md = (PGResultSetMetaData)((Object)this.getMetaData());
            this.updateValues.put(md.getBaseColumnName(columnIndex), value);
        }
    }

    protected Object getUUID(String data) throws SQLException {
        UUID uuid;
        try {
            uuid = UUID.fromString(data);
        }
        catch (IllegalArgumentException iae) {
            throw new PSQLException(GT.tr("Invalid UUID data.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)iae);
        }
        return uuid;
    }

    protected Object getUUID(byte[] data) throws SQLException {
        return new UUID(ByteConverter.int8(data, 0), ByteConverter.int8(data, 8));
    }

    void addRows(List<byte[][]> tuples) {
        this.rows.addAll(tuples);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateRef(int,Ref)");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateRef(String,Ref)");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBlob(int,Blob)");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBlob(String,Blob)");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(int,Clob)");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(String,Clob)");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnName), x);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLException("type is null");
        }
        int sqlType = this.getSQLType(columnIndex);
        if (type == BigDecimal.class) {
            if (sqlType == 2 || sqlType == 3) {
                return type.cast(this.getBigDecimal(columnIndex));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == String.class) {
            if (sqlType == 1 || sqlType == 12) {
                return type.cast(this.getString(columnIndex));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == Boolean.class) {
            if (sqlType == 16 || sqlType == -7) {
                boolean booleanValue = this.getBoolean(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return type.cast(booleanValue);
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == Short.class) {
            if (sqlType == 5) {
                short shortValue = this.getShort(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return type.cast(shortValue);
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == Integer.class) {
            if (sqlType == 4 || sqlType == 5) {
                int intValue = this.getInt(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return type.cast(intValue);
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == Long.class) {
            if (sqlType == -5) {
                long longValue = this.getLong(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return type.cast(longValue);
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == BigInteger.class) {
            if (sqlType == -5) {
                long longValue = this.getLong(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return type.cast(BigInteger.valueOf(longValue));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == Float.class) {
            if (sqlType == 7) {
                float floatValue = this.getFloat(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return type.cast(Float.valueOf(floatValue));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == Double.class) {
            if (sqlType == 6 || sqlType == 8) {
                double doubleValue = this.getDouble(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return type.cast(doubleValue);
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == java.sql.Date.class) {
            if (sqlType == 91) {
                return type.cast(this.getDate(columnIndex));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == Time.class) {
            if (sqlType == 92) {
                return type.cast(this.getTime(columnIndex));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == Timestamp.class) {
            if (sqlType == 93 || sqlType == 2013) {
                return type.cast(this.getTimestamp(columnIndex));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == Calendar.class) {
            if (sqlType == 93 || sqlType == 2013) {
                Timestamp timestampValue = this.getTimestamp(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                Calendar calendar = Calendar.getInstance(this.getDefaultCalendar().getTimeZone());
                calendar.setTimeInMillis(timestampValue.getTime());
                return type.cast(calendar);
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == Blob.class) {
            if (sqlType == 2004 || sqlType == -2 || sqlType == -5) {
                return type.cast(this.getBlob(columnIndex));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == Clob.class) {
            if (sqlType == 2005 || sqlType == -5) {
                return type.cast(this.getClob(columnIndex));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == Date.class) {
            if (sqlType == 93) {
                Timestamp timestamp = this.getTimestamp(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return type.cast(new Date(timestamp.getTime()));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == Array.class) {
            if (sqlType == 2003) {
                return type.cast(this.getArray(columnIndex));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == SQLXML.class) {
            if (sqlType == 2009) {
                return type.cast(this.getSQLXML(columnIndex));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == UUID.class) {
            return type.cast(this.getObject(columnIndex));
        }
        if (type == InetAddress.class) {
            Object addressString = this.getObject(columnIndex);
            if (addressString == null) {
                return null;
            }
            try {
                return type.cast(InetAddress.getByName(((PGobject)addressString).getValue()));
            }
            catch (UnknownHostException e) {
                throw new SQLException("could not create inet address from string '" + addressString + "'");
            }
        }
        if (type == LocalDate.class) {
            if (sqlType == 91) {
                java.sql.Date dateValue = this.getDate(columnIndex);
                if (dateValue == null) {
                    return null;
                }
                long time = dateValue.getTime();
                if (time == 9223372036825200000L) {
                    return type.cast(LocalDate.MAX);
                }
                if (time == -9223372036832400000L) {
                    return type.cast(LocalDate.MIN);
                }
                return type.cast(dateValue.toLocalDate());
            }
            if (sqlType == 93) {
                LocalDateTime localDateTimeValue = this.getLocalDateTime(columnIndex);
                if (localDateTimeValue == null) {
                    return null;
                }
                return type.cast(localDateTimeValue.toLocalDate());
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == LocalTime.class) {
            if (sqlType == 92) {
                return type.cast(this.getLocalTime(columnIndex));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == LocalDateTime.class) {
            if (sqlType == 93) {
                return type.cast(this.getLocalDateTime(columnIndex));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (type == OffsetDateTime.class) {
            if (sqlType == 2014 || sqlType == 93) {
                OffsetDateTime offsetDateTime = this.getOffsetDateTime(columnIndex);
                return type.cast(offsetDateTime);
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (PGobject.class.isAssignableFrom(type)) {
            Object object = this.isBinary(columnIndex) ? this.connection.getObject(this.getPGType(columnIndex), null, this.this_row[columnIndex - 1]) : this.connection.getObject(this.getPGType(columnIndex), this.getString(columnIndex), null);
            return type.cast(object);
        }
        throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, sqlType), PSQLState.INVALID_PARAMETER_VALUE);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public Object getObject(String s, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(s, map);
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(i, map);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getRowId columnIndex: " + columnIndex);
        throw Driver.notImplemented(this.getClass(), "getRowId(int)");
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        return this.getRowId(this.findColumn(columnName));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateRowId(int, RowId)");
    }

    @Override
    public void updateRowId(String columnName, RowId x) throws SQLException {
        this.updateRowId(this.findColumn(columnName), x);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getHoldability()");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rows == null;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNString(int, String)");
    }

    @Override
    public void updateNString(String columnName, String nString) throws SQLException {
        this.updateNString(this.findColumn(columnName), nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNClob(int, NClob)");
    }

    @Override
    public void updateNClob(String columnName, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(columnName), nClob);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNClob(int, Reader)");
    }

    @Override
    public void updateNClob(String columnName, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(columnName), reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNClob(int, Reader, long)");
    }

    @Override
    public void updateNClob(String columnName, Reader reader, long length) throws SQLException {
        this.updateNClob(this.findColumn(columnName), reader, length);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getNClob columnIndex: " + columnIndex);
        throw Driver.notImplemented(this.getClass(), "getNClob(int)");
    }

    @Override
    public NClob getNClob(String columnName) throws SQLException {
        return this.getNClob(this.findColumn(columnName));
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBlob(int, InputStream, long)");
    }

    @Override
    public void updateBlob(String columnName, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnName), inputStream, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBlob(int, InputStream)");
    }

    @Override
    public void updateBlob(String columnName, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(columnName), inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(int, Reader, long)");
    }

    @Override
    public void updateClob(String columnName, Reader reader, long length) throws SQLException {
        this.updateClob(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(int, Reader)");
    }

    @Override
    public void updateClob(String columnName, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(columnName), reader);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getSQLXML columnIndex: " + columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        return this.getSQLXML(this.this_row[columnIndex - 1], this.fields[columnIndex - 1]);
    }

    @Override
    public SQLXML getSQLXML(String columnName) throws SQLException {
        return this.getSQLXML(this.findColumn(columnName));
    }

    private SQLXML getSQLXML(byte[] data, Field field) throws SQLException {
        String str = this.getString(data, field);
        if (str == null) {
            return null;
        }
        return new PgSQLXML(this.connection, str);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.updateValue(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnName), xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        return this.getNString(this.findColumn(columnName));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getNCharacterStream columnIndex: " + columnIndex);
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnName));
    }

    public void updateNCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNCharacterStream(int, Reader, int)");
    }

    public void updateNCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNCharacterStream(int, Reader)");
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnName), x);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNCharacterStream(int, Reader, long)");
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x, long length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateCharaceterStream(int, Reader, long)");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateCharaceterStream(int, Reader)");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBinaryStream(int, InputStream, long)");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream inputStream, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), inputStream, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBinaryStream(int, InputStream)");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), inputStream);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateAsciiStream(int, InputStream, long)");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream inputStream, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), inputStream, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateAsciiStream(int, InputStream)");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), inputStream);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "isWrapperFor(Class<?>)");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "unwrap(Class<T>)");
    }

    private Calendar getDefaultCalendar() {
        TimestampUtils timestampUtils = this.connection.getTimestampUtils();
        if (timestampUtils.hasFastDefaultTimeZone()) {
            return timestampUtils.getSharedCalendar(null);
        }
        Calendar sharedCalendar = timestampUtils.getSharedCalendar(this.defaultTimeZone);
        if (this.defaultTimeZone == null) {
            this.defaultTimeZone = sharedCalendar.getTimeZone();
        }
        return sharedCalendar;
    }

    public void orderByProcess(SortColumnMetaData ... orderByList) {
        if (orderByList == null || orderByList.length == 0) {
            return;
        }
        Collections.sort(this.rows, new OrderByComparator(orderByList, this));
    }

    public void groupByProcess(SortColumnMetaData[] groupByList, TargetColumnMetaData[] targetList) {
        if (targetList == null || targetList.length == 0) {
            return;
        }
        if (groupByList != null && groupByList.length > 0) {
            Collections.sort(this.rows, new GroupByComparator(groupByList, this));
        }
        boolean hasAggregationfunctions = false;
        for (int index = 0; index < targetList.length; ++index) {
            if (targetList[index].getEntryType() != 2) continue;
            hasAggregationfunctions = true;
            break;
        }
        if (groupByList != null && groupByList.length > 0 || hasAggregationfunctions) {
            this.grouping(groupByList, targetList);
        }
    }

    private void grouping(SortColumnMetaData[] groupByList, TargetColumnMetaData[] targetList) {
        int length = groupByList.length;
        this.lastGroupValueList = new String[length];
        if (!this.initAggregationObjects(targetList)) {
            return;
        }
        if (!this.scanGroups(groupByList)) {
            return;
        }
        if (!this.setAggregationColumnNames(targetList)) {
            return;
        }
    }

    private boolean initAggregationObjects(TargetColumnMetaData ... targetList) {
        if (targetList == null) {
            return false;
        }
        if (this.aggregationFunctionList == null) {
            this.aggregationFunctionList = new ArrayList();
        } else {
            this.aggregationFunctionList.clear();
        }
        int length = targetList.length;
        for (int index = 0; index < length; ++index) {
            TargetColumnMetaData element = targetList[index];
            if (element.getEntryType() != 2) continue;
            int aggregationFunctionId = TargetColumnMetaData.parseAggregationFunctionName(element.getFunction());
            GroupByAggregator aggFunction = this.createAggregationObject(aggregationFunctionId);
            if (aggFunction == null) {
                return false;
            }
            aggFunction.setColumnIndex(index);
            this.aggregationFunctionList.add(aggFunction);
        }
        return true;
    }

    private GroupByAggregator createAggregationObject(int functionId) {
        ClientLogic clientLogic = this.connection.getClientLogic();
        GroupByAggregator aggFunction = null;
        switch (functionId) {
            case 13: {
                aggFunction = new GroupByMaxAggregator(clientLogic);
                break;
            }
            case 14: {
                aggFunction = new GroupByMinAggregator(clientLogic);
                break;
            }
            case 16: {
                aggFunction = new GroupBySumAggregator(clientLogic);
                break;
            }
            case 2: {
                aggFunction = new GroupByAvgAggregator(clientLogic);
                break;
            }
            case 7: {
                aggFunction = new GroupByCountAggregator(clientLogic);
                break;
            }
        }
        return aggFunction;
    }

    private boolean scanGroups(SortColumnMetaData ... groupByList) {
        int groupsCount = 0;
        int firstTupleInGroupIndex = 0;
        int ntups = this.rows.size();
        int tupleIndex = 0;
        while (tupleIndex < ntups) {
            byte[][] tuple = this.rows.get(tupleIndex);
            if (!this.updateLastGroupValuesArray(tuple, groupByList)) {
                return false;
            }
            this.resetAggregationObjects();
            firstTupleInGroupIndex = tupleIndex;
            while (tupleIndex < ntups && this.identicalToLastGroupValuesArray(tuple, groupByList)) {
                this.processDataAggregationObjects(tuple);
                if (++tupleIndex == ntups) break;
                tuple = this.rows.get(tupleIndex);
            }
            this.setAggregationResults(firstTupleInGroupIndex);
            byte[][] temp = this.rows.get(firstTupleInGroupIndex);
            this.rows.remove(groupsCount);
            this.rows.add(groupsCount, temp);
            ++groupsCount;
        }
        while (this.rows.size() > groupsCount) {
            this.rows.remove(this.rows.size() - 1);
        }
        return true;
    }

    private boolean updateLastGroupValuesArray(byte[][] tuple, SortColumnMetaData[] groupByList) {
        for (SortColumnMetaData element : groupByList) {
            int indexInTuple = element.getColumnIndex();
            Object objVal = null;
            try {
                objVal = this.getObjectFromByteArray(tuple[indexInTuple], this.fields[indexInTuple]);
            }
            catch (SQLException e) {
                return false;
            }
            this.lastGroupValueList[index] = objVal != null ? objVal.toString() : null;
        }
        return true;
    }

    private void resetAggregationObjects() {
        int length = this.aggregationFunctionList.size();
        for (int index = 0; index < length; ++index) {
            GroupByAggregator element = this.aggregationFunctionList.get(index);
            element.reset();
        }
    }

    private boolean identicalToLastGroupValuesArray(byte[][] tuple, SortColumnMetaData[] groupByList) {
        int length = groupByList.length;
        for (int index = 0; index < length; ++index) {
            SortColumnMetaData element = groupByList[index];
            int indexInTuple = element.getColumnIndex();
            Object val = null;
            String strVal = null;
            String reference = this.lastGroupValueList[index];
            try {
                val = this.getObjectFromByteArray(tuple[indexInTuple], this.fields[indexInTuple]);
                if (val != null) {
                    strVal = val.toString();
                }
            }
            catch (SQLException e) {
                this.connection.getLogger().error("Failed to get Object from ByteArray.");
                return false;
            }
            if (reference == null && strVal != null || reference != null && strVal == null) {
                return false;
            }
            if (reference == null || strVal == null || reference.equals(strVal)) continue;
            return false;
        }
        return true;
    }

    private boolean processDataAggregationObjects(byte[][] tuple) {
        int length = this.aggregationFunctionList.size();
        for (int index = 0; index < length; ++index) {
            GroupByAggregator element = this.aggregationFunctionList.get(index);
            int columnIndex = element.getColumnIndex();
            try {
                if (tuple[columnIndex] == null) continue;
                element.add(this.fields[columnIndex], this.getObjectFromByteArray(tuple[columnIndex], this.fields[columnIndex]));
                continue;
            }
            catch (SQLException e) {
                this.connection.getLogger().error("Failed to get Object from ByteArray.");
                return false;
            }
        }
        return true;
    }

    private void setAggregationResults(int tupleIndex) {
        int length = this.aggregationFunctionList.size();
        for (int index = 0; index < length; ++index) {
            GroupByAggregator element = this.aggregationFunctionList.get(index);
            int columnIndex = element.getColumnIndex();
            byte[] result = element.getResult();
            byte[][] row = this.rows.get(tupleIndex);
            row[columnIndex] = result;
        }
    }

    private boolean setAggregationColumnNames(TargetColumnMetaData ... targetList) {
        int length = targetList.length;
        Field[] newFieldArray = new Field[length];
        for (int index = 0; index < length; ++index) {
            TargetColumnMetaData element = targetList[index];
            if (element.getEntryType() == 2) {
                String functionTitle = element.getFunctionAliasName();
                if (functionTitle == null || functionTitle.length() == 0) {
                    functionTitle = element.getFunction();
                }
                newFieldArray[index] = new Field(functionTitle, this.fields[index].getOID(), this.fields[index].getLength(), this.fields[index].getMod(), this.fields[index].getTableOid(), this.fields[index].getPositionInTable());
                newFieldArray[index].setMetadata(this.fields[index].getMetadata());
                newFieldArray[index].setFormat(0);
                continue;
            }
            newFieldArray[index] = this.fields[index];
        }
        this.fields = newFieldArray;
        return true;
    }

    public void distinctProcess(TargetColumnMetaData[] targetList, boolean isDistinct) {
        if (!isDistinct) {
            return;
        }
        Collections.sort(this.rows, new DistinctComparator(this));
        int columnCount = this.numberOfColumnsForDistinctAll(targetList);
        this.lastDistinctValueList = new String[columnCount];
        this.removeDuplicateRows();
    }

    private int numberOfColumnsForDistinctAll(TargetColumnMetaData ... targetList) {
        int columnCount = this.fields.length;
        for (TargetColumnMetaData element : targetList) {
            if (!element.getRemoveAfterPostProcessing()) continue;
            --columnCount;
        }
        return columnCount;
    }

    private void removeDuplicateRows() {
        int insertIndex = 0;
        int index = 0;
        int ntups = this.rows.size();
        while (index < ntups) {
            int next;
            byte[][] tuple = this.rows.get(index);
            this.updateLastDistinctValuesArray(tuple);
            for (next = index + 1; next < ntups && this.identicalToLastDistinctValuesArray(tuple = this.rows.get(next)); ++next) {
            }
            byte[][] temp = this.rows.get(index);
            this.rows.remove(insertIndex);
            this.rows.add(insertIndex, temp);
            ++insertIndex;
            index = next;
        }
        while (this.rows.size() > insertIndex) {
            this.rows.remove(this.rows.size() - 1);
        }
    }

    private boolean updateLastDistinctValuesArray(byte[][] tuple) {
        int length = this.lastDistinctValueList.length;
        for (int index = 0; index < length; ++index) {
            Object objVal = null;
            try {
                objVal = this.getObjectFromByteArray(tuple[index], this.fields[index]);
            }
            catch (SQLException e) {
                this.connection.getLogger().error("Failed to get Object from ByteArray.");
                return false;
            }
            this.lastDistinctValueList[index] = objVal != null ? objVal.toString() : null;
        }
        return true;
    }

    private boolean identicalToLastDistinctValuesArray(byte[][] tuple) {
        int length = this.lastDistinctValueList.length;
        for (int index = 0; index < length; ++index) {
            String value = null;
            Object objVal = null;
            String reference = this.lastDistinctValueList[index];
            try {
                objVal = this.getObjectFromByteArray(tuple[index], this.fields[index]);
            }
            catch (SQLException e) {
                this.connection.getLogger().error("Failed to get Object from ByteArray.");
                return false;
            }
            if (objVal != null) {
                value = objVal.toString();
            }
            if (reference == null && value != null || reference != null && value == null) {
                return false;
            }
            if (reference == null || value == null || reference.equals(value)) continue;
            return false;
        }
        return true;
    }

    public void limitOffsetProcess(LimitOffsetMetaData limitOffset) {
        if (limitOffset.isOffsetSet()) {
            for (int index = 0; index < limitOffset.getOffset() && !this.rows.isEmpty(); ++index) {
                this.rows.remove(0);
            }
        }
        if (limitOffset.isLimitSet()) {
            while (this.rows.size() > limitOffset.getLimit()) {
                this.rows.remove(this.rows.size() - 1);
            }
        }
    }

    public void removeArtificiallyAddedColumnsProcess(TargetColumnMetaData ... targetList) {
        int columnCount = this.numberOfColumnsForDistinctAll(targetList);
        Field[] newFieldArray = new Field[columnCount];
        System.arraycopy(this.fields, 0, newFieldArray, 0, columnCount);
        this.fields = newFieldArray;
    }

    private Object getObjectFromByteArray(byte[] data, Field field) throws SQLException {
        if (data == null) {
            return null;
        }
        switch (this.getSQLType(field)) {
            case -7: 
            case 16: {
                return this.getBoolean(data, field);
            }
            case 2009: {
                return this.getSQLXML(data, field);
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getInt(data, field);
            }
            case -5: {
                return this.getLong(data, field);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(data, field, field.getMod() == -1 ? -1 : field.getMod() - 4 & 0xFFFF);
            }
            case 7: {
                return Float.valueOf(this.getFloat(data, field));
            }
            case 6: 
            case 8: {
                return this.getDouble(data, field);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(data, field);
            }
            case 91: {
                return this.getDate(data, field);
            }
            case 92: {
                return this.getTime(data, field);
            }
            case 93: {
                return this.getTimestamp(data, field, null);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(data, field);
            }
            case 2003: {
                return this.getArray(data, field);
            }
            case 2005: {
                return this.getClob(data, field);
            }
            case 2004: {
                return this.getBlob(data, field);
            }
        }
        return this.getDefaultValue(data, field);
    }

    private Object getDefaultValue(byte[] data, Field field) throws SQLException {
        String type = this.getPGType(field);
        if ("unknown".equals(type)) {
            return this.getString(data, field);
        }
        if ("uuid".equals(type)) {
            if (this.isBinary(field)) {
                return this.getUUID(data);
            }
            return this.getUUID(this.getString(data, field));
        }
        if ("refcursor".equals(type)) {
            String cursorName = this.getString(data, field);
            StringBuilder sb = new StringBuilder("FETCH ALL IN ");
            Utils.escapeIdentifier(sb, cursorName, this.connection.getCompatibilityMode());
            ResultSet rs = this.connection.execSQLQuery(sb.toString(), this.resultsettype, 1007);
            sb.setLength(0);
            sb.append("CLOSE ");
            Utils.escapeIdentifier(sb, cursorName, this.connection.getCompatibilityMode());
            this.connection.execSQLUpdate(sb.toString());
            if (!(rs instanceof PgResultSet)) {
                return rs;
            }
            PgResultSet pgResultSet = (PgResultSet)rs;
            pgResultSet.setRefCursor(cursorName);
            return rs;
        }
        if ("hstore".equals(type)) {
            if (this.isBinary(field)) {
                return HStoreConverter.fromBytes(data, this.connection.getEncoding());
            }
            return HStoreConverter.fromString(this.getString(data, field));
        }
        return null;
    }

    private static int compareBooleanValues(Object obj1, Object obj2) {
        boolean val2;
        if (!(obj1 instanceof Boolean) || !(obj2 instanceof Boolean)) {
            return 0;
        }
        boolean val1 = (Boolean)obj1;
        if (val1 == (val2 = ((Boolean)obj2).booleanValue())) {
            return 0;
        }
        if (val1 && !val2) {
            return 1;
        }
        return -1;
    }

    private static int compareIntegerValues(Object obj1, Object obj2) {
        int val2;
        if (!(obj1 instanceof Integer) || !(obj2 instanceof Integer)) {
            return 0;
        }
        int val1 = (Integer)obj1;
        if (val1 == (val2 = ((Integer)obj2).intValue())) {
            return 0;
        }
        if (val1 > val2) {
            return 1;
        }
        return -1;
    }

    private static int compareLongValues(Object obj1, Object obj2) {
        long val2;
        if (!(obj1 instanceof Long) || !(obj2 instanceof Long)) {
            return 0;
        }
        long val1 = (Long)obj1;
        if (val1 == (val2 = ((Long)obj2).longValue())) {
            return 0;
        }
        if (val1 > val2) {
            return 1;
        }
        return -1;
    }

    private static int compareDecimalValues(Object obj1, Object obj2) {
        if (!(obj1 instanceof BigDecimal) || !(obj2 instanceof BigDecimal)) {
            return 0;
        }
        BigDecimal val1 = (BigDecimal)obj1;
        BigDecimal val2 = (BigDecimal)obj2;
        return val1.compareTo(val2);
    }

    private static int compareFloatValues(Object obj1, Object obj2) {
        if (!(obj1 instanceof Float) || !(obj2 instanceof Float)) {
            return 0;
        }
        float val1 = ((Float)obj1).floatValue();
        float val2 = ((Float)obj2).floatValue();
        float epsilon = Float.MIN_NORMAL;
        if (Math.abs(val1 - val2) < epsilon) {
            return 0;
        }
        if (val1 > val2) {
            return 1;
        }
        return -1;
    }

    private static int compareDoubleValues(Object obj1, Object obj2) {
        if (!(obj1 instanceof Double) || !(obj2 instanceof Double)) {
            return 0;
        }
        double val1 = (Double)obj1;
        double val2 = (Double)obj2;
        double epsilon = Double.MIN_NORMAL;
        if (Math.abs(val1 - val2) < epsilon) {
            return 0;
        }
        if (val1 > val2) {
            return 1;
        }
        return -1;
    }

    private static int compareStringValues(Object obj1, Object obj2, boolean isCaseSensitive) {
        if (!(obj1 instanceof String) || !(obj2 instanceof String)) {
            return 0;
        }
        String val1 = (String)obj1;
        String val2 = (String)obj2;
        if (!isCaseSensitive) {
            val1 = val1.toUpperCase(Locale.ENGLISH);
            val2 = val2.toUpperCase(Locale.ENGLISH);
        }
        return val1.compareTo(val2);
    }

    private static int compareDateValues(Object obj1, Object obj2) {
        if (!(obj1 instanceof java.sql.Date) || !(obj2 instanceof java.sql.Date)) {
            return 0;
        }
        java.sql.Date val1 = (java.sql.Date)obj1;
        java.sql.Date val2 = (java.sql.Date)obj2;
        return val1.compareTo(val2);
    }

    private static int compareTimeValues(Object obj1, Object obj2) {
        if (!(obj1 instanceof Time) || !(obj2 instanceof Time)) {
            return 0;
        }
        Time val1 = (Time)obj1;
        Time val2 = (Time)obj2;
        if (val1.equals(val2)) {
            return 0;
        }
        if (val1.before(val2)) {
            return 1;
        }
        return -1;
    }

    private static int compareTimestampValues(Object obj1, Object obj2) {
        if (!(obj1 instanceof Timestamp) || !(obj2 instanceof Timestamp)) {
            return 0;
        }
        Timestamp val1 = (Timestamp)obj1;
        Timestamp val2 = (Timestamp)obj2;
        if (val1.equals(val2)) {
            return 0;
        }
        if (val1.before(val2)) {
            return 1;
        }
        return -1;
    }

    private static int compareComplexValues(Object obj1, Object obj2, boolean isCaseSensitive) {
        boolean isVal2Null;
        String val1 = obj1.toString();
        String val2 = obj2.toString();
        boolean isVal1Null = val1 == null;
        boolean bl = isVal2Null = val2 == null;
        if (!isCaseSensitive) {
            if (!isVal1Null) {
                val1 = val1.toUpperCase(Locale.ENGLISH);
            }
            if (!isVal2Null) {
                val2 = val2.toUpperCase(Locale.ENGLISH);
            }
        }
        if (!isVal1Null && !isVal2Null) {
            return val1.compareTo(val2);
        }
        return 0;
    }

    public int compareValues(byte[] p1, byte[] p2, Field field, boolean isCaseSensitive) throws SQLException {
        Object obj1 = this.getObjectFromByteArray(p1, field);
        Object obj2 = this.getObjectFromByteArray(p2, field);
        switch (this.getSQLType(field)) {
            case -7: 
            case 16: {
                return PgResultSet.compareBooleanValues(obj1, obj2);
            }
            case -6: 
            case 4: 
            case 5: {
                return PgResultSet.compareIntegerValues(obj1, obj2);
            }
            case -5: {
                return PgResultSet.compareLongValues(obj1, obj2);
            }
            case 2: 
            case 3: {
                return PgResultSet.compareDecimalValues(obj1, obj2);
            }
            case 7: {
                return PgResultSet.compareFloatValues(obj1, obj2);
            }
            case 6: 
            case 8: {
                return PgResultSet.compareDoubleValues(obj1, obj2);
            }
            case -1: 
            case 1: 
            case 12: {
                return PgResultSet.compareStringValues(obj1, obj2, isCaseSensitive);
            }
            case 91: {
                return PgResultSet.compareDateValues(obj1, obj2);
            }
            case 92: {
                return PgResultSet.compareTimeValues(obj1, obj2);
            }
            case 93: {
                return PgResultSet.compareTimestampValues(obj1, obj2);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2009: {
                return PgResultSet.compareComplexValues(obj1, obj2, isCaseSensitive);
            }
        }
        return 0;
    }

    static class NullObject
    extends PGobject {
        NullObject(String type) {
            this.setType(type);
        }

        @Override
        public String getValue() {
            return null;
        }
    }

    private class PrimaryKey {
        int index;
        String name;

        PrimaryKey(int index, String name) {
            this.index = index;
            this.name = name;
        }

        Object getValue() throws SQLException {
            return PgResultSet.this.getObject(this.index);
        }
    }

    public class CursorResultHandler
    extends ResultHandlerBase {
        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor) {
            PgResultSet.this.rows = tuples;
            try {
                PgResultSet.this.clientLogicGetData(true);
            }
            catch (SQLException e) {
                this.handleError(new SQLException(e.getMessage()));
            }
            PgResultSet.this.cursor = cursor;
        }

        @Override
        public void handleCommandStatus(String status, long updateCount, long insertOID) {
            this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", status), PSQLState.PROTOCOL_VIOLATION));
        }

        @Override
        public void handleCompletion() throws SQLException {
            SQLWarning warning = this.getWarning();
            if (warning != null) {
                PgResultSet.this.addWarning(warning);
            }
            super.handleCompletion();
        }
    }
}

