/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.reset;

import java.util.Objects;

public class AdvisoryLock {
    private String sessionId;
    private String classId;
    private String objId;
    private String mode;

    public AdvisoryLock(String sessionId, String classId, String objId, String mode) {
        this.sessionId = sessionId;
        this.classId = classId;
        this.objId = objId;
        this.mode = mode;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getClassId() {
        return this.classId;
    }

    public void setClassId(String classId) {
        this.classId = classId;
    }

    public String getObjId() {
        return this.objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String convertToSql() {
        if ("ExclusiveLock".equals(this.mode)) {
            if ("0".equals(this.classId)) {
                return String.format("select pg_catalog.pg_advisory_lock(%s)", this.objId);
            }
            return String.format("select pg_catalog.pg_advisory_lock(%s, %s)", this.classId, this.objId);
        }
        if ("0".equals(this.classId)) {
            return String.format("select pg_catalog.pg_advisory_lock_shared(%s)", this.objId);
        }
        return String.format("select pg_catalog.pg_advisory_lock_shared(%s, %s)", this.classId, this.objId);
    }

    public String toString() {
        return "AdvisoryLock{sessionId='" + this.sessionId + '\'' + ", classId='" + this.classId + '\'' + ", objId='" + this.objId + '\'' + ", mode='" + this.mode + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdvisoryLock)) {
            return false;
        }
        AdvisoryLock that = (AdvisoryLock)o;
        return Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.classId, that.classId) && Objects.equals(this.objId, that.objId) && Objects.equals(this.mode, that.mode);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.classId, this.objId, this.mode);
    }
}

