/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.qos;

import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.qos.DataProcess;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class QoSTask {
    private static Log LOGGER = Logger.getLogger(QoSTask.class.getName());
    private static final int MIN_THREADS = 2;
    private static final int MAX_THREADS = 64;
    private static final int MAX_BLOCK_QUEUE = 100;
    private static ThreadPoolExecutor qosThreadPool = new ThreadPoolExecutor(2, 64, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), new DaemonThreadFactory());
    private Map<String, Integer> connectedMap = new HashMap<String, Integer>();

    public void monitor(String dstHost, Integer dstPort, int connectTimeout) throws UnknownHostException {
        InetAddress host = InetAddress.getByName(dstHost);
        String key = dstHost + ":" + dstPort;
        if (!this.connectedMap.containsKey(key)) {
            this.connectedMap.put(key, dstPort);
            Task task = new Task(host, dstPort, connectTimeout);
            qosThreadPool.execute(task);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("create new task ip = " + dstHost + " port = " + dstPort + " success! Start monitor...");
            }
        }
    }

    public String toString() {
        return "QoSTask{connectedMap=" + this.connectedMap + '}';
    }

    public void release() {
        qosThreadPool.shutdown();
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler(new QoSUncaughtExceptionHandler());
            return thread;
        }

        private static class QoSUncaughtExceptionHandler
        implements Thread.UncaughtExceptionHandler {
            private QoSUncaughtExceptionHandler() {
            }

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.error("Create qosTask failed!", e);
            }
        }
    }

    private class Task
    implements Runnable {
        private InetAddress dstHost;
        private Integer dstPort;
        private Integer connectTimeout;
        private boolean isStop = false;

        public Task(InetAddress dstHost, Integer dstPort, Integer connectTimeout) {
            this.dstHost = dstHost;
            this.dstPort = dstPort;
            this.connectTimeout = connectTimeout;
        }

        private boolean shouldStop() {
            return this.isStop;
        }

        private void startTask() throws InterruptedException {
            DataProcess dataProcess = new DataProcess(this.dstHost, this.dstPort, this.connectTimeout);
            while (!this.shouldStop()) {
                dataProcess.monitor();
                TimeUnit.MILLISECONDS.sleep(dataProcess.getTimeInterval());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Monitor Task stopped ip:" + this.dstHost + " port:" + this.dstPort);
            }
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.startTask();
                }
                catch (InterruptedException e) {
                    if (!LOGGER.isErrorEnabled()) break block2;
                    LOGGER.error("Monitor task run error. Error message: ", e);
                }
            }
        }
    }
}

