/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jetcd.interceptor;

import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.jetcd.JetcdServiceType;
import com.lubanops.apm.plugin.jetcd.JetcdUtils;
import io.etcd.jetcd.api.CampaignResponse;
import io.etcd.jetcd.api.CompactionResponse;
import io.etcd.jetcd.api.DeleteRangeResponse;
import io.etcd.jetcd.api.KeyValue;
import io.etcd.jetcd.api.LeaderKey;
import io.etcd.jetcd.api.LeaderResponse;
import io.etcd.jetcd.api.LeaseGrantResponse;
import io.etcd.jetcd.api.LeaseRevokeResponse;
import io.etcd.jetcd.api.LeaseTimeToLiveResponse;
import io.etcd.jetcd.api.ProclaimResponse;
import io.etcd.jetcd.api.PutResponse;
import io.etcd.jetcd.api.RangeResponse;
import io.etcd.jetcd.api.ResignResponse;
import io.etcd.jetcd.api.TxnResponse;
import io.etcd.jetcd.api.lock.LockResponse;
import io.etcd.jetcd.api.lock.UnlockResponse;
import java.util.List;

class ResponseProcessHelper {
    ResponseProcessHelper() {
    }

    public static void parseAndProcessRequest(Object request, SpanEvent spanEvent, JetcdServiceType type) {
        if (request == null || spanEvent == null || type == null) {
            return;
        }
        switch (type) {
            case KV: {
                ResponseProcessHelper.parseKVResponseAndAddTag(request, spanEvent);
                break;
            }
            case LEASE: {
                ResponseProcessHelper.parseLeaseResponseAndAddTag(request, spanEvent);
                break;
            }
            case LOCK: {
                ResponseProcessHelper.parseLockResponseAndAddTag(request, spanEvent);
                break;
            }
            case ELECTION: {
                ResponseProcessHelper.parseElectionResponseAndAddTag(request, spanEvent);
                break;
            }
        }
    }

    public static void parseKVResponseAndAddTag(Object response, SpanEvent spanEvent) {
        if (response != null && spanEvent != null) {
            if (response instanceof RangeResponse) {
                ResponseProcessHelper.addTag4RangeResponse((RangeResponse)response, spanEvent);
            } else if (response instanceof PutResponse) {
                ResponseProcessHelper.addTag4PutResponse((PutResponse)response, spanEvent);
            } else if (response instanceof DeleteRangeResponse) {
                ResponseProcessHelper.addTag4DeleteRangeResponse((DeleteRangeResponse)response, spanEvent);
            } else if (response instanceof TxnResponse) {
                ResponseProcessHelper.addTag4TxnResponse((TxnResponse)response, spanEvent);
            } else if (response instanceof CompactionResponse) {
                ResponseProcessHelper.addTag4CompactionResponse((CompactionResponse)response, spanEvent);
            }
        }
    }

    public static void addTag4RangeResponse(RangeResponse response, SpanEvent spanEvent) {
        List kvsList = response.getKvsList();
        boolean more = response.getMore();
        long count = response.getCount();
        spanEvent.addTag("kvs", JetcdUtils.getKvsAsTag(kvsList));
        spanEvent.addTag("more", String.valueOf(more));
        spanEvent.addTag("count", String.valueOf(count));
    }

    public static void addTag4PutResponse(PutResponse response, SpanEvent spanEvent) {
        KeyValue prevKv = response.getPrevKv();
        spanEvent.addTag("prev_kv", JetcdUtils.getKvAsTag(prevKv));
    }

    public static void addTag4DeleteRangeResponse(DeleteRangeResponse response, SpanEvent spanEvent) {
        long deleted = response.getDeleted();
        List prevKvsList = response.getPrevKvsList();
        spanEvent.addTag("deleted", String.valueOf(deleted));
        spanEvent.addTag("prev_kv", JetcdUtils.getKvsAsTag(prevKvsList));
    }

    public static void addTag4TxnResponse(TxnResponse response, SpanEvent spanEvent) {
    }

    public static void addTag4CompactionResponse(CompactionResponse response, SpanEvent spanEvent) {
    }

    public static void parseLeaseResponseAndAddTag(Object response, SpanEvent spanEvent) {
        if (response != null && spanEvent != null) {
            if (response instanceof LeaseGrantResponse) {
                ResponseProcessHelper.addTag4LeaseGrantResponse((LeaseGrantResponse)response, spanEvent);
            } else if (response instanceof LeaseRevokeResponse) {
                ResponseProcessHelper.addTag4LeaseRevokeResponse((LeaseRevokeResponse)response, spanEvent);
            } else if (response instanceof LeaseTimeToLiveResponse) {
                ResponseProcessHelper.addTag4LeaseTimeToLiveResponse((LeaseTimeToLiveResponse)response, spanEvent);
            }
        }
    }

    public static void addTag4LeaseGrantResponse(LeaseGrantResponse response, SpanEvent spanEvent) {
        long ttl = response.getTTL();
        long id = response.getID();
        String error = JetcdUtils.getTruncatedTag(response.getError());
        spanEvent.addTag("responded ttl", String.valueOf(ttl));
        spanEvent.addTag("responded id", String.valueOf(id));
        if (!StringUtils.isBlank((String)error)) {
            spanEvent.addTag("error", error);
        }
    }

    public static void addTag4LeaseRevokeResponse(LeaseRevokeResponse response, SpanEvent spanEvent) {
    }

    public static void addTag4LeaseTimeToLiveResponse(LeaseTimeToLiveResponse response, SpanEvent spanEvent) {
        long ttl = response.getTTL();
        long id = response.getID();
        spanEvent.addTag("responded ttl", String.valueOf(ttl));
        spanEvent.addTag("responded id", String.valueOf(id));
    }

    public static void parseLockResponseAndAddTag(Object response, SpanEvent spanEvent) {
        if (response != null && spanEvent != null) {
            if (response instanceof LockResponse) {
                ResponseProcessHelper.addTag4LockResponse((LockResponse)response, spanEvent);
            } else if (response instanceof UnlockResponse) {
                ResponseProcessHelper.addTag4UnlockResponse((UnlockResponse)response, spanEvent);
            }
        }
    }

    public static void addTag4LockResponse(LockResponse response, SpanEvent spanEvent) {
        String key = response.getKey().toStringUtf8();
        spanEvent.addTag("key", key);
    }

    public static void addTag4UnlockResponse(UnlockResponse response, SpanEvent spanEvent) {
    }

    public static void parseElectionResponseAndAddTag(Object response, SpanEvent spanEvent) {
        if (response != null && spanEvent != null) {
            if (response instanceof CampaignResponse) {
                ResponseProcessHelper.addTag4CampaignResponse((CampaignResponse)response, spanEvent);
            } else if (response instanceof ProclaimResponse) {
                ResponseProcessHelper.addTag4ProclaimResponse((ProclaimResponse)response, spanEvent);
            } else if (response instanceof LeaderResponse) {
                ResponseProcessHelper.addTag4LeaderResponse((LeaderResponse)response, spanEvent);
            } else if (response instanceof ResignResponse) {
                ResponseProcessHelper.addTag4ResignResponse((ResignResponse)response, spanEvent);
            }
        }
    }

    public static void addTag4CampaignResponse(CampaignResponse response, SpanEvent spanEvent) {
        LeaderKey leader = response.getLeader();
        spanEvent.addTag("leader", JetcdUtils.getLeaderKeyAsTag(leader));
    }

    public static void addTag4ProclaimResponse(ProclaimResponse response, SpanEvent spanEvent) {
    }

    public static void addTag4LeaderResponse(LeaderResponse response, SpanEvent spanEvent) {
        KeyValue kv = response.getKv();
        spanEvent.addTag("kv", JetcdUtils.getKvAsTag(kv));
    }

    public static void addTag4ResignResponse(ResignResponse response, SpanEvent spanEvent) {
    }
}

