/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.httpasyncclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientCollector;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import io.opentelemetry.api.trace.Span;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpRequest;

public class GenerateRequestInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable()) {
                HttpRequest request = (HttpRequest)result;
                SpanEvent spanEvent = (SpanEvent)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"spanevent");
                this.setHeaders(spanEvent, request);
            }
        }
        catch (Exception generateRequestInterceptor) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)generateRequestInterceptor);
        }
    }

    private void setHeaders(SpanEvent spanEvent, HttpRequest request) {
        String userFlag;
        String gTraceId;
        Header[] envIdHeaders = request.getHeaders(Headers.ENV_ID.getValue());
        if (envIdHeaders != null && envIdHeaders.length > 0) {
            request.removeHeaders(Headers.ENV_ID.getValue());
        }
        request.addHeader(Headers.ENV_ID.getValue(), String.valueOf(IdentityConfigManager.getEnvId()));
        Header[] domainIdHeaders = request.getHeaders(Headers.DOMAIN_ID.getValue());
        if (domainIdHeaders != null && domainIdHeaders.length > 0) {
            request.removeHeaders(Headers.DOMAIN_ID.getValue());
        }
        request.addHeader(Headers.DOMAIN_ID.getValue(), String.valueOf(IdentityConfigManager.getDomainId()));
        Header[] domainTypeHeaders = request.getHeaders(Headers.DOMAIN_TYPE.getValue());
        if (domainTypeHeaders != null && domainTypeHeaders.length > 0) {
            request.removeHeaders(Headers.DOMAIN_TYPE.getValue());
        }
        request.addHeader(Headers.DOMAIN_TYPE.getValue(), String.valueOf(IdentityConfigManager.getDomainType()));
        if (spanEvent != null) {
            String nextSpanId = spanEvent.generateNextSpanId();
            String traceId = spanEvent.getTraceId();
            Header[] traceIdHeaders = request.getHeaders(Headers.TRACE_ID.getValue());
            if (traceIdHeaders != null && traceIdHeaders.length > 0) {
                request.removeHeaders(Headers.TRACE_ID.getValue());
                request.removeHeaders(Headers.SPAN_ID.getValue());
                request.removeHeaders(Headers.SOURCE_EVENT_ID.getValue());
                request.removeHeaders(Headers.POLICY_ID.getValue());
                request.removeHeaders(Headers.OTEL_HEADER.name());
            }
            request.addHeader(Headers.TRACE_ID.getValue(), traceId);
            request.addHeader(Headers.SPAN_ID.getValue(), nextSpanId);
            request.addHeader(Headers.SOURCE_EVENT_ID.getValue(), spanEvent.getEventId());
            request.addHeader(Headers.POLICY_ID.getValue(), spanEvent.getPolicyId());
            HashMap<String, String> headers = new HashMap<String, String>();
            TraceCollector.injectHeader(headers, (Span)spanEvent.getOtelSpan());
            if (!headers.isEmpty()) {
                headers.forEach((k, v) -> request.addHeader(k, v));
            }
        }
        if (!StringUtils.isBlank((String)(gTraceId = TraceCollector.getVirtualTraceId()))) {
            request.addHeader(Headers.GTRACE_ID.getValue(), gTraceId);
        }
        if (!StringUtils.isBlank((String)(userFlag = TraceCollector.getUserFlag()))) {
            request.addHeader(Headers.USER_FLAG.getValue(), userFlag);
        }
    }
}

