/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.sql.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.StatsBase;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.utils.ExceptionUtil;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class SqlExceptionValue
implements StatsBase {
    private volatile int countOld;
    private AtomicInteger count = new AtomicInteger(0);
    private AtomicReference<String> message = new AtomicReference();
    private AtomicReference<String> stackTrace = new AtomicReference();
    private AtomicReference<String> sql = new AtomicReference();

    public void onThrowable(Throwable t, String sql) {
        this.count.incrementAndGet();
        if (this.message.get() == null) {
            this.message.set(t.getMessage());
        }
        if (this.stackTrace.get() == null) {
            String s = ExceptionUtil.getThrowableStackTrace((Throwable)t, (boolean)ConfigManager.isHideExceptionMessage());
            this.stackTrace.set(s);
        }
        if (this.sql.get() == null) {
            this.sql.set(sql);
        }
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow result = new MonitorDataRow();
        result.put((Object)"count", (Object)this.count.get());
        result.put((Object)"message", (Object)this.message.get());
        result.put((Object)"stackTrace", (Object)this.stackTrace.get());
        result.put((Object)"sql", (Object)this.sql.get());
        return result;
    }

    public MonitorDataRow harvest() {
        int countNew = this.count.get();
        int errorCount = countNew - this.countOld;
        if (errorCount > 0) {
            String sqlstring;
            String st;
            MonitorDataRow result = new MonitorDataRow();
            result.put((Object)"count", (Object)errorCount);
            this.countOld = countNew;
            String m = this.message.getAndSet(null);
            if (m != null) {
                result.put((Object)"message", (Object)m);
            }
            if ((st = (String)this.stackTrace.getAndSet(null)) != null) {
                result.put((Object)"stackTrace", (Object)st);
            }
            if ((sqlstring = (String)this.sql.getAndSet(null)) != null) {
                result.put((Object)"sql", (Object)sqlstring);
            }
            return result;
        }
        return null;
    }
}

