/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.httpclient.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultStatusCodeAggregator;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HostAggregator;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientParameterEnum;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.InvocationAggregator;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.UrlPattern;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import java.util.HashMap;
import java.util.Map;

public class HttpClientCollector
extends Collector {
    public static final HttpClientCollector INSTANCE = new HttpClientCollector();
    private static final InvocationAggregator INVOCATION_AGGREGATOR = new InvocationAggregator();
    private static final HostAggregator HOST_AGGREGATOR = new HostAggregator();
    private static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();
    private static final DefaultStatusCodeAggregator STATUS_CODE_AGGREGATOR = new DefaultStatusCodeAggregator();
    private static volatile int expectedErrorCode = 400;
    private volatile boolean isNeedGetBody;
    private volatile int maxBodyLength = 1024;

    public static String onStart(String hostUri, String requestUri, String method, String client) {
        String targetUrl = HttpClientCollector.getTargetUrl(requestUri);
        if (targetUrl != null) {
            INVOCATION_AGGREGATOR.onStart(hostUri, targetUrl, method, client);
        }
        return targetUrl;
    }

    public static Map<String, Object> onStartAsync(String hostUri, String requestUri, String method, String client) {
        String targetUrl = HttpClientCollector.getTargetUrl(requestUri);
        if (targetUrl != null) {
            return INVOCATION_AGGREGATOR.onStartAsync(hostUri, targetUrl, method, client);
        }
        return new HashMap<String, Object>();
    }

    public static void onThrowable(Throwable t) {
        boolean flag = INVOCATION_AGGREGATOR.onThrowable(t);
        if (flag) {
            EXCEPTION_AGGREGATOR.onThrowable(t);
        }
    }

    public static void onThrowableAsync(Throwable t, Map<String, Object> map, String traceId) {
        boolean flag = INVOCATION_AGGREGATOR.onThrowableAsync(t, map, traceId);
        if (flag) {
            EXCEPTION_AGGREGATOR.onThrowable(t);
        }
    }

    public static void onStatusCode(String url, int code) {
        STATUS_CODE_AGGREGATOR.onStatusCode(url, code);
        if (code >= expectedErrorCode) {
            INVOCATION_AGGREGATOR.onError();
        }
    }

    public static void onStatusCodeAsync(String url, int code, Map<String, Object> map, String traceId) {
        STATUS_CODE_AGGREGATOR.onStatusCode(url, code);
        if (code >= expectedErrorCode) {
            INVOCATION_AGGREGATOR.onErrorAsync(map, traceId);
        }
    }

    public static void onResponseClose(String envId) {
        if (envId == null) {
            envId = INVOCATION_AGGREGATOR.getHost();
        }
        if (envId != null) {
            HOST_AGGREGATOR.onResponseClose(envId, INVOCATION_AGGREGATOR.getStartTime(), INVOCATION_AGGREGATOR.getError(), INVOCATION_AGGREGATOR.getHost());
        }
        INVOCATION_AGGREGATOR.onResponseClose(envId);
    }

    public static void clear() {
        INVOCATION_AGGREGATOR.clearThreadLocal();
    }

    public static void onResponseCloseAsync(String envId, Map map, String traceId) {
        Boolean isError;
        if (envId == null) {
            envId = (String)map.get("host");
        }
        if ((isError = (Boolean)map.get("error")) == null) {
            isError = false;
        }
        HOST_AGGREGATOR.onResponseClose(envId, (Long)map.get("starttime"), isError, (String)map.get("host"));
        INVOCATION_AGGREGATOR.onResponseCloseAsync(envId, map, traceId);
    }

    private static String trimToPrefix(String url) {
        int i = -1;
        i = url.indexOf(63);
        return i <= 0 ? url : url.substring(0, i);
    }

    public static String getTargetUrl(String requestUri) {
        int endIndex;
        if ((requestUri = HttpClientCollector.trimToPrefix(requestUri)).startsWith("http") && (endIndex = requestUri.indexOf("/", 8)) > 0) {
            requestUri = requestUri.substring(endIndex);
        }
        if (InvocationAggregator.getPatterns() != null) {
            for (UrlPattern urlPattern : InvocationAggregator.getPatterns()) {
                String targetUrl = urlPattern.getTargetUrl(requestUri);
                if (targetUrl == null) continue;
                return targetUrl;
            }
        }
        return requestUri;
    }

    public String getCollectorName() {
        return "HttpClient";
    }

    public void parseParameter(Map<String, String> parameters) {
        Boolean isNeedGetBodyNew;
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        this.isNeedGetBody = (isNeedGetBodyNew = ParameterParseUtil.getBoolean(parameters, (String)HttpClientParameterEnum.needBody.name())) != null ? isNeedGetBodyNew : false;
        Integer maxBodyLengthNew = ParameterParseUtil.getInteger(parameters, (String)HttpClientParameterEnum.maxBodyLength.name());
        this.maxBodyLength = maxBodyLengthNew != null && maxBodyLengthNew > 0 ? maxBodyLengthNew : 1024;
    }

    public boolean isNeedGetBody() {
        return this.isNeedGetBody;
    }

    public int getMaxBodyLength() {
        return this.maxBodyLength;
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)INVOCATION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)HOST_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)STATUS_CODE_AGGREGATOR);
        INSTANCE.register();
    }
}

